###############################################################################
# Copyright (C) 2006, 2007 Mariano Spadaccini	mariano@marianospadaccini.it  #
#									      #
# This file is part of MacAddressLocator.                                     #
#                                                                             #
#  MacAddressLocator is free software; you can redistribute it and/or modify  #
#  it under the terms of the GNU General Public License as published by       #
#  the Free Software Foundation; either version 2 of the License, or          #
#  (at your option) any later version.                                        #
#                                                                             #
#  MacAddressLocator is distributed in the hope that it will be useful,       #
#  but WITHOUT ANY WARRANTY; without even the implied warranty of             #
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              #
#  GNU General Public License for more details.                               #
#                                                                             #
#  You should have received a copy of the GNU General Public License          #
#  along with Foobar; if not, write to the Free Software                      #
#  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA #
###############################################################################

package myFunctionShell;

use lib '/home/spadaccini/develop/mal/mal/inc';
use strict;
use warnings;

use Param qw(:version);

# Clear screen
sub clearScreen {
    system 'clear';
}

# print page header
sub printHeader {
    my ( $text, $text2 ) = @_;
    print "\t\tMAC Address Locator - mal v", $version;

    if ( $text =~ /main\.pl$/ ) {
        print ' - main';
    }
    elsif ( $text =~ /find_mac\.pl$/ ) {
        print ' - Find a MAC';
    }
    elsif ( $text =~ /find_switch.pl$/ ) {
        print ' - Get MAC list of switch port';
    }
    elsif ( $text =~ /manage_switch.pl$/ ) {
        print ' - Manage switch';
    }
    elsif ( $text =~ /list_switch.pl$/ ) {
        print ' - Switch list from DB';
    }
    elsif ( $text =~ /add_switch.pl$/ ) {
        print ' - Add switch into DB';
    }
    elsif ( $text =~ /sync_switch.pl$/ ) {
        print ' - Syncronization switch info';
    }
    elsif ( $text =~ /enable_switch.pl$/ ) {
        print ' - Enable/Disable switch';
    }
    print "\n";
}

# type to continue...
sub typeToContinue {
    print "\n\n\n\tPress Return to continue... ";
    my $type = <STDIN>;
    exit 0;
}

1;
