#!$<$perl_path$>$

###############################################################################
# Copyright (C) 2006, 2007 Mariano Spadaccini	mariano@marianospadaccini.it  #
#									      #
# This file is part of MacAddressLocator.                                     #
#                                                                             #
#  MacAddressLocator is free software; you can redistribute it and/or modify  #
#  it under the terms of the GNU General Public License as published by       #
#  the Free Software Foundation; either version 2 of the License, or          #
#  (at your option) any later version.                                        #
#                                                                             #
#  MacAddressLocator is distributed in the hope that it will be useful,       #
#  but WITHOUT ANY WARRANTY; without even the implied warranty of             #
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              #
#  GNU General Public License for more details.                               #
#                                                                             #
#  You should have received a copy of the GNU General Public License          #
#  along with Foobar; if not, write to the Free Software                      #
#  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA #
###############################################################################

use lib '$<$pathFile$>$/inc';
use strict;
use warnings;

#use myFunctionAlg;
use myFunctionDB;
use myFunctionUtils;
use myFunctionShell;
use myFunctionNet;
use Net::SNMP qw(:snmp);

use ParamSNMP qw(:swFetch :config);

# clear the screen
myFunctionShell::clearScreen;

# Header of 'sync_switch.pl'
myFunctionShell::printHeader($0);

# it gets from you an switch's ip address
my ( $IP, $checkedIP );

# Eval if defined IP
if ( defined( $ARGV[0] ) ) {
    $IP        = $ARGV[0];
    $checkedIP = myFunctionUtils::checkIP($IP);
}
else {
    $checkedIP = 0;    # False
}

# it gets from you a switch's ip address
while ( !$checkedIP ) {
    print "\n\tPlease, You must insert a IP address:\t";
    $IP = <STDIN>;
    chomp $IP;
    $checkedIP = myFunctionUtils::checkIP($IP);
}

# it makes reachability test
#if (myFunctionNet::testReachability($IP)) {
#    print "\nok\n";
#} else {
#    print "\nno ok\n";
#}

#### Connect to DB
my $dbh = myFunctionDB::connectToDB;

# it gets switch parameters from DB
my ( $idSwitch, $IPSwitch, $MACSwitch, $SNMPversion ) =
  myFunctionDB::getSwitchParametersFromDB( $dbh,
    myFunctionDB::getSwitchIDFromIP( $IP, $dbh ) );

# it gets remote switch parameters
my ( $session, $error ) = Net::SNMP->session(
    -version   => myFunctionUtils::textSNMPversion($SNMPversion),
    -hostname  => $IPSwitch,
    -community => $getCommunity
);

# If not defined session... is switch busy??
if ( !defined($session) ) {
    myFunctionUtils::traceLog( "ERROR: $error", 1 );
    exit 1;
}
else {
    myFunctionUtils::traceLog( "\n\tI'm connected with switch $IPSwitch", 2 );
}

my ($result) =
  $session->get_request(
    -varbindlist => [ $swName, $swDescr, $swLocation, $swMAC ], );

# cleanup mac address
$result->{$swMAC} = myFunctionUtils::cleanedUpMAC( $result->{$swMAC} );

my %switchParams = (
    name        => $result->{$swName},
    description => $result->{$swDescr},
    comment     => $result->{$swLocation},
    PhysAddress => $result->{$swMAC},
);

# Print data stored in switch
print "\n\n\tData in switch";
print "\n\t\tname:\t\t";
defined( $result->{$swName} ) ? print $result->{$swName} : print '';
print "\n\t\tdescription:\t", $result->{$swDescr};
print "\n\t\tcomment:\t";
defined( $result->{$swLocation} ) ? print $result->{$swLocation} : print '';
print "\n\t\tmac:\t\t", $result->{$swMAC};

# It gets switch parameters from DB
my ( $nameSwitch, $descriptionSwitch, $commentSwitch, $snmp_versionSwitch ) =
  myFunctionDB::getSwitchOtherParamsFromID( $idSwitch, $dbh );

# Print data stored in DB
print "\n\n\tData in DB";
print "\n\t\tname:\t\t";
defined($nameSwitch) ? print $nameSwitch : print '';
print "\n\t\tdescription:\t";
defined($descriptionSwitch) ? print $descriptionSwitch : print '';
print "\n\t\tcomment:\t";
defined($commentSwitch) ? print $commentSwitch : print '';
print "\n\t\tmac:\t\t", $MACSwitch;

# it asks: sync?
my ($risp);
do {
    print "\n\n\tSyncronization info (data switch -> data DB)? [y/n] ";
    $risp = <STDIN>;
    chomp $risp;
    $risp = lc($risp);
} while ( !( ( $risp eq 'n' ) || ( $risp eq 'y' ) ) );

if ( $risp eq 'n' ) {

    # Now NOT sync
    print "\n\n\tOk, I do NOT syncronization switch info.";
}
else {

    # Now sync data switch with data DB
    print "\n\n\tStarting syncronization switch info...";
    my $query_where = 'id=' . $idSwitch;
    myFunctionDB::setSwitchParamsFromID( $dbh, $idSwitch, \%switchParams,
        $query_where );
    print " done";
}

# press type to continue...
myFunctionShell::typeToContinue;

exit 0;
