#!$<$perl_path$>$

###############################################################################
# Copyright (C) 2006, 2007 Mariano Spadaccini	mariano@marianospadaccini.it  #
#									      #
# This file is part of MacAddressLocator.                                     #
#                                                                             #
#  MacAddressLocator is free software; you can redistribute it and/or modify  #
#  it under the terms of the GNU General Public License as published by       #
#  the Free Software Foundation; either version 2 of the License, or          #
#  (at your option) any later version.                                        #
#                                                                             #
#  MacAddressLocator is distributed in the hope that it will be useful,       #
#  but WITHOUT ANY WARRANTY; without even the implied warranty of             #
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              #
#  GNU General Public License for more details.                               #
#                                                                             #
#  You should have received a copy of the GNU General Public License          #
#  along with Foobar; if not, write to the Free Software                      #
#  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA #
###############################################################################

use lib '$<$pathFile$>$/inc';
use strict;
use warnings;

use myFunctionUtils;
use myFunctionShell;
use myFunctionDB;

use ParamSNMP qw(:swFetch);

# clear the screen
myFunctionShell::clearScreen;

# Header of 'list_switch.pl'
myFunctionShell::printHeader($0);

#### Connect to DB
my $dbh = myFunctionDB::connectToDB;

#### Gets switch list
my $sth = myFunctionDB::listSwitch($dbh);
print "\n", ' ' x 10, 'ID', ' ' x 8, 'IP', ' ' x 12, 'Name', ' ' x 15, 'Enable';
while ( my %switch = $sth->fetchhash ) {
    print "\n", ' ' x 8;
    printf( "%3s    %-15s %-18s",
        $switch{'id'}, $switch{'ip'}, $switch{'name'} );
    print ' ' x 7;
    $switch{'disable'} == 0 ? print 'Y' : print 'N';
}

# press type to continue...
myFunctionShell::typeToContinue;

exit 0;
