#!$<$perl_path$>$

###############################################################################
# Copyright (C) 2006, 2007 Mariano Spadaccini	mariano@marianospadaccini.it  #
#									      #
# This file is part of MacAddressLocator.                                     #
#                                                                             #
#  MacAddressLocator is free software; you can redistribute it and/or modify  #
#  it under the terms of the GNU General Public License as published by       #
#  the Free Software Foundation; either version 2 of the License, or          #
#  (at your option) any later version.                                        #
#                                                                             #
#  MacAddressLocator is distributed in the hope that it will be useful,       #
#  but WITHOUT ANY WARRANTY; without even the implied warranty of             #
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              #
#  GNU General Public License for more details.                               #
#                                                                             #
#  You should have received a copy of the GNU General Public License          #
#  along with Foobar; if not, write to the Free Software                      #
#  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA #
###############################################################################

use lib '$<$pathFile$>$/inc';
use strict;
use warnings;

use myFunctionAlg;
use myFunctionDB;
use myFunctionUtils;
use myFunctionShell;

# clear the screen
myFunctionShell::clearScreen;

# Header of 'find_mac.pl'
myFunctionShell::printHeader($0);

# it gets from you an switch's ip address
my ( $IP, $checkedIP );
do {
    print "\n\tPlease, You must insert a IP address:\t";
    $IP = <STDIN>;
    chomp $IP;
    $checkedIP = myFunctionUtils::checkIP($IP);
} while ( !$checkedIP );

# it gets from you an switch's port
my ( $Port, $checkedPort );
do {
    print "\n\tPlease, You must insert a switch port:\t";
    $Port = <STDIN>;
    chomp $Port;
    $checkedPort = myFunctionUtils::checkPort($Port);
} while ( !$checkedPort );

#### Connect to DB
my $dbh = myFunctionDB::connectToDB;

# Evaluate my timeShoot
my $timeShoot = myFunctionUtils::timeNow();

# print Header
my $msg = "Date $timeShoot\tTime $timeShoot";
print "\n\nReporting ", myFunctionUtils::getDateFromNowDateTime(), " - ",
  myFunctionUtils::getTimeFromNowDateTime();
print " for switch address $IP\n";

print "\n\t    ", " " x 25, "Number\t   Older\t   Last";

# Count how many entry for switch's port
my $countEntryForSwitchPort =
  myFunctionDB::countEntryForSwitchPort( $IP, $Port, $dbh );

# Get older entry (get older inserted datetime in db) for raw mac
my $olderTimeEntryForSwitchPort;

# Get last entry (get last inserted/updated datetime in DB) for raw mac
my $lastTimeEntryForSwitchPort;

if ( $countEntryForSwitchPort > 0 ) {
    $olderTimeEntryForSwitchPort =
      myFunctionDB::getTimeEntryForSwitchPort( $IP, $Port, $dbh, 'older' );
    $lastTimeEntryForSwitchPort =
      myFunctionDB::getTimeEntryForSwitchPort( $IP, $Port, $dbh, 'last' );
}
else {
    $olderTimeEntryForSwitchPort = '-';
    $lastTimeEntryForSwitchPort  = '-';
}

print "\nEntry for switch $IP:$Port",
  " " x ( 19 - length($IP) - length($Port) );
print " " x ( 4 - length($countEntryForSwitchPort) ),
  "$countEntryForSwitchPort";
print " " x ( 17 - length($olderTimeEntryForSwitchPort) ),
  $olderTimeEntryForSwitchPort;
print " " x ( 9 - length($lastTimeEntryForSwitchPort) ),
  "      $lastTimeEntryForSwitchPort";

# If entry for switch's port is == 0, I finished here
if ( $countEntryForSwitchPort == 0 ) {

    # press type to continue...
    myFunctionShell::typeToContinue;
}

print "\nList of mac in DB for $IP:$Port";

# Get list of macaddress from switch's port
my $sth = myFunctionDB::getListMACFromSwitchPort( $IP, $Port, $dbh );
print "\n", " " x 7, 'mac address', " " x 13, "date time";
while ( my %hashListFromSwitchPort = $sth->fetchhash ) {
    print "\n", " " x 7, $hashListFromSwitchPort{'mac'};
    print " " x 7, myFunctionUtils::transformDatetimeInHumanDatetime(
        $hashListFromSwitchPort{'time'} );
}

# press type to continue...
myFunctionShell::typeToContinue;

exit 0;
