#!$<$perl_path$>$

###############################################################################
# Copyright (C) 2006, 2007 Mariano Spadaccini	mariano@marianospadaccini.it  #
#									      #
# This file is part of MacAddressLocator.                                     #
#                                                                             #
#  MacAddressLocator is free software; you can redistribute it and/or modify  #
#  it under the terms of the GNU General Public License as published by       #
#  the Free Software Foundation; either version 2 of the License, or          #
#  (at your option) any later version.                                        #
#                                                                             #
#  MacAddressLocator is distributed in the hope that it will be useful,       #
#  but WITHOUT ANY WARRANTY; without even the implied warranty of             #
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              #
#  GNU General Public License for more details.                               #
#                                                                             #
#  You should have received a copy of the GNU General Public License          #
#  along with Foobar; if not, write to the Free Software                      #
#  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA #
###############################################################################

use lib '$<$pathFile$>$/inc';
use strict;
use warnings;

use myFunctionAlg;
use myFunctionDB;
use myFunctionUtils;
use myFunctionShell;

# clear the screen
myFunctionShell::clearScreen;

# Header of 'find_mac.pl'
myFunctionShell::printHeader($0);

# it gets from you an raw mac address
my ( $rawMAC, $checkedMAC );
do {
    print "\n\tPlease, You must insert a mac address:\t";
    $rawMAC = <STDIN>;
    chomp $rawMAC;
    $checkedMAC = myFunctionUtils::checkMAC($rawMAC);
} while ( !$checkedMAC );

# cleaned up MAC (trasform mac in lower case, erase ':' and/or '-' and/or ' ' )
my $cleanedUpMAC = myFunctionUtils::cleanedUpMAC($rawMAC);

#### Connect to DB
my $dbh = myFunctionDB::connectToDB;

# Evaluate my timeShoot
my $timeShoot = myFunctionUtils::timeNow();

# print Header
my $msg = "Date $timeShoot\tTime $timeShoot";
print "\n\nReporting ", myFunctionUtils::getDateFromNowDateTime(), " - ",
  myFunctionUtils::getTimeFromNowDateTime();
print " for mac address $rawMAC\n";

print "\n\t    ", " " x 25, "Number\t   Older\t   Last";

# Count how many entry for raw mac (family mac?)
my $countEntryForMAC = myFunctionDB::countEntryForMAC( $cleanedUpMAC, $dbh );

# Get older entry (get older inserted datetime in db) for raw mac
my $olderTimeEntryForMAC;

# Get last entry (get last inserted/updated datetime in DB) for raw mac
my $lastTimeEntryForMAC;

if ( $countEntryForMAC > 0 ) {

    #    print $countEntryForMAC;
    $olderTimeEntryForMAC =
      myFunctionDB::getOlderTimeEntryForMAC( $cleanedUpMAC, $dbh );
    $lastTimeEntryForMAC =
      myFunctionDB::getLastTimeEntryForMAC( $cleanedUpMAC, $dbh );
}
else {
    $olderTimeEntryForMAC = '-';
    $lastTimeEntryForMAC  = '-';
}

print "\nEntry for mac $rawMAC", " " x ( 22 - length($rawMAC) ),
  " " x ( 5 - length($countEntryForMAC) ), "$countEntryForMAC";
print " " x ( 9 - length($olderTimeEntryForMAC) ),
  "      $olderTimeEntryForMAC";
print " " x ( 9 - length($lastTimeEntryForMAC) ), "      $lastTimeEntryForMAC";

# If entry for mac address is != 1, I finished here
if ( $countEntryForMAC != 1 ) {

    # press type to continue...
    myFunctionShell::typeToContinue;
}

my $correctMAC = myFunctionDB::getMACFromRawMAC( $cleanedUpMAC, $dbh );

print "\nEntry mac in DB $correctMAC";

print "\n", " " x 30, "Last", " " x 8, "IP Switch", " " x 7, "Port", " " x 5,
  "Description";

# get story of mac address
my $sth = myFunctionDB::getMACstory( $cleanedUpMAC, $dbh );
while ( my %hashStory = $sth->fetchhash ) {
    print "\n", " " x 27,
      myFunctionUtils::transformDatetimeInHumanDate( $hashStory{'time'} );
    print " " x ( 15 - length( $hashStory{'ip'} ) ), $hashStory{'ip'};
    print " " x 5, " " x ( 3 - length( $hashStory{'port'} ) ),
      $hashStory{'port'};
    print " " x 7, $hashStory{'description'};
}

# press type to continue...
myFunctionShell::typeToContinue;

exit 0;
