#!$<$perl_path$>$

###############################################################################
# Copyright (C) 2006, 2007 Mariano Spadaccini	mariano@marianospadaccini.it  #
#									      #
# This file is part of MacAddressLocator.				      #
#									      #
#  MacAddressLocator is free software; you can redistribute it and/or modify  #
#  it under the terms of the GNU General Public License as published by	      #
#  the Free Software Foundation; either version 2 of the License, or	      #
#  (at your option) any later version.					      #
#									      #
#  MacAddressLocator is distributed in the hope that it will be useful,	      #
#  but WITHOUT ANY WARRANTY; without even the implied warranty of	      #
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	      #
#  GNU General Public License for more details.				      #
#									      #
#  You should have received a copy of the GNU General Public License	      #
#  along with Foobar; if not, write to the Free Software		      #
#  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA #
###############################################################################

use lib '$<$pathFile$>$';
use lib '$<$pathFile$>$/inc';
use strict;
use warnings;
use Net::SNMP qw(:snmp);

BEGIN {
    use ParamSNMP qw(:config);
}

use myFunctionAlg;
use myFunctionDB;
use myFunctionUtils;

# Am I already running?
myFunctionUtils::alreadyRunning;

#### Connect to DB
my $dbh = myFunctionDB::connectToDB;

# Create three array: switches's ip, switches's mac address, switches's SNMP version
my ( $idSwitch, $IPSwitch, $MACSwitch, $SNMPversion ) =
  myFunctionDB::getSwitchParametersFromDB($dbh);

# Evaluate my timeShoot
my $timeShoot = myFunctionUtils::timeNow();

# Insert timeShoot into DB
myFunctionDB::insertTimeShoot( $timeShoot, $dbh );

# get idTimeShoot from db
my $idTimeShoot = myFunctionDB::getIDTimeShoot( $timeShoot, $dbh );

if ( $parallel == 0 ) {

    ####    Connect to switches via SNMP
    for ( my $i = 0 ; $i < @$IPSwitch ; $i++ ) {

        # check SNMP version
        if ( $$SNMPversion[$i] == 2 ) {
            my ( $session, $error ) = Net::SNMP->session(
                -version     => 'snmpv2c',
                -nonblocking => 1,
                -hostname    => $$IPSwitch[$i],
                -community   => $getCommunity,
            );

            # If not defined session... is switch busy??
            if ( !defined($session) ) {
                myFunctionUtils::traceLog( "ERROR: $error", 1 );
                exit 1;
            }

            my ( $tableMAC, $tablePort, $tableStatus );
            my $result = $session->get_bulk_request(
                -callback => [
                    \&table_cb,   $tableMAC,      $tablePort,
                    $tableStatus, $$IPSwitch[$i], $$idSwitch[$i],
                    $MACSwitch
                ],
                -maxrepetitions => 5,
                -varbindlist    => [$subtree]
            );

            # If not defined result...
            if ( !defined($result) ) {
                myFunctionUtils::traceLog( "ERROR: $session->error", 1 );
                $session->close;
                exit 1;
            }
            else {
                myFunctionUtils::traceLog(
                    "I'm connected with switch $$IPSwitch[$i]", 1 );
            }

# It's only for debug
#	myFunctionUtils::traceLog("Now address IP: $$IPSwitch[$i]\t id: $$idSwitch[$i]", 1);

            snmp_dispatcher();
            $session->close;

        }
        else {
            my ( $session, $error ) = Net::SNMP->session(
                -version   => 'snmpv1',
                -hostname  => $$IPSwitch[$i],
                -community => $getCommunity,
            );

            # If not defined session... is switch busy??
            if ( !defined($session) ) {
                myFunctionUtils::traceLog( "ERROR: $error", 1 );
                exit 1;
            }
            else {
                myFunctionUtils::traceLog(
                    "I'm connected with switch $$IPSwitch[$i]", 1 );
            }

            my ( $tableMAC, $tablePort, $tableStatus );
            my $result;
            if (
                defined(
                    $result = $session->get_table( -baseoid => $subtree )
                )
              )
            {
                foreach my $oid ( oid_lex_sort( keys( %{$result} ) ) ) {
                    if ( oid_base_match( $mac_list, $oid ) ) {
                        $tableMAC->{$oid} = $session->var_bind_list->{$oid};
                        myFunctionUtils::traceLog(
                            "\tCurrent value: " . $tableMAC->{$oid}, 3 );
                    }
                    elsif ( oid_base_match( $mac_port, $oid ) ) {
                        $tablePort->{$oid} = $session->var_bind_list->{$oid};
                        myFunctionUtils::traceLog(
                            "\tCurrent value: " . $tablePort->{$oid}, 3 );
                    }
                    elsif ( oid_base_match( $mac_status, $oid ) ) {
                        $tableStatus->{$oid} = $session->var_bind_list->{$oid};
                        myFunctionUtils::traceLog(
                            "\tCurrent value: " . $tableStatus->{$oid}, 3 );
                    }
                }
            }
            else {
                myFunctionUtils::traceLog( "ERROR: $session->error", 1 );
            }

  # This function upload DB, but clear the MAC associates with the uplink's port
            myFunctionAlg::UploadDBrawMAC( \$tableMAC, \$tablePort,
                \$tableStatus, $$IPSwitch[$i], $$idSwitch[$i], $MACSwitch,
                $idTimeShoot, $dbh );
            $session->close;
        }
    }

    myFunctionUtils::traceLog( "Now I'm processing next switch", 1 );
}

myFunctionUtils::traceLog( "Now I'm finished", 1 );

exit 0;

sub table_cb {
    my ( $session, $tableMAC, $tablePort, $tableStatus, $ipSwitch, $idSwitch,
        $ref_MACSwitch )
      = @_;
    myFunctionUtils::traceLog( "This oids are fetch by SNMP", 4 );
    if ( !defined( $session->var_bind_list ) ) {
        myFunctionUtils::traceLog( "ERROR: $session->error", 1 );
    }
    else {

        # Loop through each of the OIDs in the response and assign
        # the key/value pairs to the anonymous hash that is passed
        # to the callback.
        my $next;
        foreach my $oid ( oid_lex_sort( keys( %{ $session->var_bind_list } ) ) )
        {
            if ( !oid_base_match( $subtree, $oid ) ) {
                $next = undef;
                last;
            }

            $next = $oid;
            if ( oid_base_match( $mac_list, $oid ) ) {
                $$tableMAC->{$oid} = $session->var_bind_list->{$oid};
                $$tableMAC->{$oid} =
                  myFunctionUtils::cleanedUpMAC( $$tableMAC->{$oid} );
                myFunctionUtils::traceLog(
                    "\tCurrent value: " . $$tableMAC->{$oid}, 3 );
            }
            elsif ( oid_base_match( $mac_port, $oid ) ) {
                $$tablePort->{$oid} = $session->var_bind_list->{$oid};
                myFunctionUtils::traceLog(
                    "\tCurrent value: " . $$tablePort->{$oid}, 3 );
            }
            elsif ( oid_base_match( $mac_status, $oid ) ) {
                $$tableStatus->{$oid} = $session->var_bind_list->{$oid};
                myFunctionUtils::traceLog(
                    "\tCurrent value: " . $$tableStatus->{$oid}, 3 );
            }
            myFunctionUtils::traceLog( "\tCurrent oid: " . $oid, 3 );
        }

        # If $next is defined we need to send another request
        # to get more of the table.
        if ( defined($next) ) {
            my $result = $session->get_bulk_request(
                -callback => [
                    \&table_cb,   $tableMAC, $tablePort,
                    $tableStatus, $ipSwitch, $idSwitch,
                    $ref_MACSwitch
                ],
                -maxrepetitions => 5,
                -varbindlist    => [$next]
            );
            if ( !defined($result) ) {
                myFunctionUtils::traceLog( "ERROR: $session->error", 3 );
            }
        }
        else {

  # This function upload DB, but clear the MAC associates with the uplink's port
            myFunctionAlg::UploadDBrawMAC( $tableMAC, $tablePort, $tableStatus,
                $ipSwitch, $idSwitch, $ref_MACSwitch, $idTimeShoot, $dbh );
        }
    }
}
