### This is installer for MacAddressLocator.
### This software is designed and developed to localize the mac address.

###############################################################################
# Copyright (C) 2006, 2007 Mariano Spadaccini   mariano@marianospadaccini.it  #
#									      #
# This file is part of MacAddressLocator.                                     #
#									      #
#  MacAddressLocator is free software; you can redistribute it and/or modify  #
#  it under the terms of the GNU General Public License as published by       #
#  the Free Software Foundation; either version 2 of the License, or          #
#  (at your option) any later version.                                        #
#  									      #
#  MacAddressLocator is distributed in the hope that it will be useful,       #
#  but WITHOUT ANY WARRANTY; without even the implied warranty of             #
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              #
#  GNU General Public License for more details.                               #
#  									      #
#  You should have received a copy of the GNU General Public License          #
#  along with Foobar; if not, write to the Free Software                      #
#  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA #
###############################################################################

print "I verified the presence of some packages\n";
my $package = 'strict';
eval {require strict} and PackageIsPresent($package) or PackageIsNotPresent($package);
my $package = 'warnings';
eval {require warnings} and PackageIsPresent($package) or PackageIsNotPresent($package);
my $package = 'Net::SNMP';
eval {require Net::SNMP} and PackageIsPresent($package) or PackageIsNotPresent($package);
my $package = 'Mysql';
eval {require Mysql} and PackageIsPresent($package) or PackageIsNotPresent($package);
my $package = 'Exporter';
eval {require Exporter} and PackageIsPresent($package) or PackageIsNotPresent($package);
#my $package = 'File::Copy';
#eval {require File::Copy} and PackageIsPresent($package) or PackageIsNotPresent($package);
print "\n\n";


use strict;
use warnings;
#use File::Copy;

my $version = '0.5.0';

my $perlPath = `which perl`;

print "Try to install...\n\n\n";

# Now, I will ask a few question
print "----- General information for install `MacAddressLocator'.\n";
print "      You can install it where you prefer; example: `/var/perl/snmp/mal'.\n";
print "      However, you must have permission for write in this location.\n\n";
my $filePath;
my ($directoryExist, $directoryNotExist);
do {
    print "Where do you prefer to install MacAddressLocator........\t";
    $filePath = <STDIN>;
    chomp $filePath;
    my $destinationDir = $filePath . '/mal';
    open(FILEHANDLE, $filePath);
    if (!(-e FILEHANDLE)) {
	$directoryNotExist = 1;
	print "\n\t\tDirectory $filePath NOT exist!!\n\n";
    } else {
	$directoryNotExist = 0;
	close(FILEHANDLE);
    }
    if (-e $destinationDir) {
	$directoryExist = 1;
	print "\n\t\tDestination directory $destinationDir already exist!!\n\n";
    } else {
	$directoryExist = 0;
    }
} while (($filePath eq '') or ($directoryExist) or ($directoryNotExist));

$filePath .= '/mal';

print "\n\n----- Configure your verbosity level.\n";
print "      For developer, ``verbose'' must have almost `1'.\n";
print "      For ordinary use, ``verbose'' would have `0'.\n\n";

my $verboseLevel;
do {
    print "What's your prefer ``verbose'' level?....{0, ..., 10}\t";
    $verboseLevel = <STDIN>;
    chomp $verboseLevel;
} while !(($verboseLevel >= 0) and ($verboseLevel <= 10));

print "\n\n----- Configure your SNMP community.\n";
print "      For this software you must to insert only GET community.\n\n";
my $getCommunity;
do {
    print "What's your getCommunity?......\t";
    $getCommunity = <STDIN>;
    chomp $getCommunity;
} while ($getCommunity eq '');

print "\n\n----- Configure your DB account.\n";
print "      For this software you must have INSERT and UPDATE permission.\n";
print "      You must to insert a db setting for your account.\n";
print "      Often this software (client for DB) is in same server machine: in this case,\n";
print "           you can write `localhost' as `DB host'.\n\n";
my $yourDB;
do {
    print "What's your `DB name'?.......\t";
    $yourDB = <STDIN>;
    chomp $yourDB;
} while ($yourDB eq '');

my $userDB;
do {
    print "What's your `DB user'?.......\t";
    $userDB = <STDIN>;
    chomp $userDB;
} while ($userDB eq '');

my $pwdDB;
do {
    print "What's your `DB password'?...\t";
    $pwdDB = <STDIN>;
    chomp $pwdDB;
} while ($pwdDB eq '');

my $hostDB;
do {
    print "What's your `DB host'?.......\t";
    $hostDB = <STDIN>;
    chomp $hostDB;
} while ($hostDB eq '');



my $fileList;
$fileList->{main}->{srcPath} = './main';
$fileList->{main}->{dstPath} = $filePath;
$fileList->{main}->{files} = [ `\\find ./main -type f -printf '%P\n'` ];
$fileList->{inc}->{srcPath} = './inc';
$fileList->{inc}->{dstPath} = $filePath . '/inc';
$fileList->{inc}->{files} = [ `\\find ./inc -type f -printf '%P\n'` ];
$fileList->{utils}->{srcPath} = './utils';
$fileList->{utils}->{dstPath} = $filePath . '/utils';
$fileList->{utils}->{files} = [ `\\find ./utils -type f -printf '%P\n'` ];



# Now, I create some directories and its files
mkdir ($filePath, 0755) && print "\ncreation directory $filePath...\tok" || die "Error in directory creations $filePath: error $!";
foreach my $subDirectory (keys %$fileList) {
    mkdir ($fileList->{$subDirectory}->{dstPath}, 0755) && print "\ncreation directory $fileList->{$subDirectory}->{dstPath}...    ok" or die "Error in directory creations $fileList->{$subDirectory}->{dstPath}: error $!" unless (-e $fileList->{$subDirectory}->{dstPath});
    foreach my $fileName (@{ $fileList->{$subDirectory}->{files} }) {
	chomp $fileName;
	printf "\n    copying file %-40s", "$fileList->{$subDirectory}->{srcPath}/$fileName...";
	open FHin, "<$fileList->{$subDirectory}->{srcPath}/$fileName";
	my @lines = <FHin>;
	close FHin;
	my $currentFile = $fileList->{$subDirectory}->{dstPath} . "/" . $fileName;
	open FHout, ">$currentFile";
	foreach my $line (@lines) {
	    $line = change($line, $perlPath, $version, $filePath, $verboseLevel, $getCommunity, $yourDB, $userDB, $pwdDB, $hostDB);
	    print FHout $line;
	}
	close FHout;
	print " ok";
   }
}

print "\n\n";
## Try to copy common files
print 'Copying common files...';
system "\\cp -Rf ./copyright README CHANGELOG $filePath";
system "\\ln -s copyright $filePath/copyleft";
system "\\ln -s copyright/gpl.txt $filePath/COPYING";
print " copied.\n";

print "\n\nTry to change permissions for some scripts...";

# Try to change executable permission for some scripts
my $destinationFile = $filePath . '/main.pl'; 
chmodFile($destinationFile);

$destinationFile = $filePath . '/mal_today_develop.pl'; 
chmodFile($destinationFile);

for (@{ $fileList->{utils}->{files} }) {
    chomp();
    my $newPath = $filePath . '/utils/' . $_;
    chmodFile($newPath);
}

print "\n\n...finished.\n\n";
print "\n\n";
print "Now, you must create SCHEMA for DB. You can write\n";
print "\t\tmysql -u $userDB -p $yourDB < schema/SCHEMA.mysql\n\n";



#  Try change executable permission
sub chmodFile {
    my $destinationFile = shift;

    # Try change permission for $destinationFile
    my $chmod = chmod 0766, $destinationFile;

    if ($chmod) {
        print " ok...";
    } else {
        print "\n\t DON'T ok!!";
        print "\n\t\t\t You must write `chmod 544 $destinationFile'";
    }
}

sub PackageIsPresent {
    my $package = shift;
    print "$package...\tis present\n";
}

sub PackageIsNotPresent {
    my $package = shift;
    print "$package...\tis NOT present\n";
    die "\nYou can search the package '$package' on http://search.cpan.org/\n\n";
}

sub change {
    my ($line, $perlPath, $version, $filePath, $verboseLevel, $getCommunity, $yourDB, $userDB, $pwdDB, $hostDB) = @_;
    $_ = $line;
    $_ =~ s/\$<\$perl_path\$>\$/$perlPath/;
    $_ =~ s/\$<\$version\$>\$/$version/;
    $_ =~ s/\$<\$pathFile\$>\$/$filePath/;
    $_ =~ s/\'\$<\$verboseLevel\$>\$\'/$verboseLevel/;
    $_ =~ s/\$<\$getCommunity\$>\$/$getCommunity/;
    $_ =~ s/\$<\$mysqlDB\$>\$/$yourDB/;
    $_ =~ s/\$<\$userDB\$>\$/$userDB/;
    $_ =~ s/\$<\$pwdDB\$>\$/$pwdDB/;
    $_ =~ s/\$<\$hostDB\$>\$/$hostDB/;
    return $_;
}
