###############################################################################
# Copyright (C) 2006, 2007 Mariano Spadaccini	mariano@marianospadaccini.it  #
#									      #
# This file is part of MacAddressLocator.                                     #
#                                                                             #
#  MacAddressLocator is free software; you can redistribute it and/or modify  #
#  it under the terms of the GNU General Public License as published by       #
#  the Free Software Foundation; either version 2 of the License, or          #
#  (at your option) any later version.                                        #
#                                                                             #
#  MacAddressLocator is distributed in the hope that it will be useful,       #
#  but WITHOUT ANY WARRANTY; without even the implied warranty of             #
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              #
#  GNU General Public License for more details.                               #
#                                                                             #
#  You should have received a copy of the GNU General Public License          #
#  along with Foobar; if not, write to the Free Software                      #
#  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA #
###############################################################################

package myFunctionDB;

use strict;
use warnings;
use Mysql;

use ParamDB qw(:config);
use Param qw(:config);

#use myFunctionUtils;

# This function return connection DB handle
sub connectToDB {
    #### Connect to database
    my $dbh = Mysql->connect( $mysql_host, $mysql_db, $mysql_user, $mysql_pwd );
    return $dbh;
}

# Switch list from DB
sub listSwitch {
    my ($dbh) = @_;

    # Get all (id, ip, ...) from $DBlistSwitch
    my $query = "SELECT id, name, ip, disable FROM $DBlistSwitch";
    my $sth   = $dbh->query($query);
    return $sth;
}

# Insert switch into DB (ip and SNMP version)
sub insertSwitch {
    my ( $dbh, $IP, $SNMPVersion ) = @_;

    # Get last id from DB
    my $query   = "SELECT max(id) as max FROM $DBlistSwitch";
    my $sth     = $dbh->query($query);
    my ($maxID) = $sth->fetchrow;

    # Eval max id
    if ( defined($maxID) ) {
        $maxID += 1;
    }
    else {
        $maxID = 1;
    }

    # Insert the switch
    $query =
"INSERT INTO $DBlistSwitch (id, ip, snmp_version, disable, inserted) VALUES ($maxID, '$IP', '$SNMPVersion', 1, now())";
    $sth = $dbh->query($query);

    return $maxID;
}

# Gets switches parameters from DB (ip address, mac address and SNMP version)
sub getSwitchParametersFromDB {
    my ( $dbh, $id ) = @_;

    #### Create query
    my $query =
"SELECT id, ip, PhysAddress, snmp_version FROM $DBlistSwitch WHERE disable=0";
    if ( defined($id) ) {
        $query .= " AND id=$id";
    }
    else {
        $query .= ' ORDER BY id';
    }

    if ( defined($id) ) {
        #### query to database
        my $sth = $dbh->query($query);
        my ( $idSwitch, $IPSwitch, $MACSwitch, $SNMPversion ) = $sth->fetchrow;

        # return id, IP, mac and SNMP version of the switch
        return ( $idSwitch, $IPSwitch, $MACSwitch, $SNMPversion );
    }
    else {
        #### query to database
        my $sth         = $dbh->query($query);
        my @idSwitch    = $sth->fetchcol(0);
        my @IPSwitch    = $sth->fetchcol(1);
        my @MACSwitch   = $sth->fetchcol(2);
        my @SNMPversion = $sth->fetchcol(3);

        # return id, IP, mac and SNMP version of the switch
        return ( \@idSwitch, \@IPSwitch, \@MACSwitch, \@SNMPversion );
    }
}

# Get switch id from ip
sub getSwitchIDFromIP {
    my ( $IP, $dbh ) = @_;
    #### Create query
    my $query = "SELECT id FROM $DBlistSwitch WHERE ip='$IP' AND disable=0";

    #### query to database
    my $sth      = $dbh->query($query);
    my $idSwitch = $sth->fetchrow;
    return $idSwitch;
}

# Get switch name from DB
sub getSwitchOtherParamsFromID {
    my ( $id, $dbh ) = @_;
    #### Create query
    my $query =
"SELECT name, description, comment, snmp_version FROM $DBlistSwitch WHERE id='$id'";

    #### query to database
    my $sth = $dbh->query($query);
    my ( $name, $description, $comment, $snmp_version ) = $sth->fetchrow;
    return ( $name, $description, $comment, $snmp_version );
}

# Update switch parameters into DB
sub setSwitchParamsFromID {
    my ( $dbh, $id, $params, $query_where ) = @_;
    #### Create query
    my $query = "UPDATE $DBlistSwitch SET ";
    while ( my ( $key, $value ) = each %$params ) {
        $query .= $key . "='" . $value . "'";
        $query .= ", ";
    }
    $query = substr $query, 0, length($query) - 2;
    $query .= " WHERE " . $query_where;
    my $sth = $dbh->query($query);
}

# Insert/Update location in db
sub updateLocation {

    #    my ($mac, $ipSwitch, $idSwitch, $port, $status, $timeShoot, $dbh) = @_;
    my ( $mac, $idSwitch, $port, $status, $idTimeShoot, $dbh ) = @_;

    my $idMAC = getMacIDFromDB( $mac, $dbh );

    # Get last ID (last entry code) for mac from the same switch in db
    my $lastIDLoc =
      myFunctionDB::getLastIDFromDB( $idMAC, $idSwitch, $port, $dbh );

    # If there isn't entry in db
    if ( not defined($lastIDLoc) ) {

        # Insert entry in db
        myFunctionDB::insertMACLocInDB( $idMAC, $idSwitch, $port, $status,
            $idTimeShoot, $dbh );
    }
    else {

        # Update time in db
        myFunctionDB::updateMACLocInDB( $lastIDLoc, $status, $idTimeShoot,
            $dbh );
    }
}

# Get last mac's idSwitch from db
sub getLastIDFromDB {
    my ( $idMAC, $idSwitch, $port, $dbh ) = @_;

    #### Create query
    my $query =
"SELECT id FROM $DBlistLocation WHERE idMAC='$idMAC' AND idSwitch='$idSwitch' AND port='$port' ORDER BY idTimeShoot DESC LIMIT 1";
    myFunctionUtils::traceLog( $query, 3 );

    #### query to database
    my $sth = $dbh->query($query);
    return $sth->fetchrow;
}

# get mac's id from db
sub getMacIDFromDB {
    my ( $mac, $dbh ) = @_;

    #### Create query
    my $query = "SELECT id FROM $DBlistMAC WHERE macaddress='$mac'";
    myFunctionUtils::traceLog( $query, 3 );

    #### query to database
    my $sth   = $dbh->query($query);
    my $idMAC = $sth->fetchrow;

    if ( not defined $idMAC ) {
        myFunctionDB::insertMACinDB( $mac, $dbh );

        # Re-Fetch mac in db
        myFunctionUtils::traceLog( $query, 3 );
        $sth   = $dbh->query($query);
        $idMAC = $sth->fetchrow;
    }
    return $idMAC;
}

# Insert macaddress in db
sub insertMACinDB {
    my ( $mac, $dbh ) = @_;

    my $timeNow = myFunctionUtils::timeNow();

    # Create query
    my $query =
"INSERT INTO $DBlistMAC (macaddress, inserted) VALUES ('$mac', '$timeNow')";
    myFunctionUtils::traceLog( $query, 3 );

    #### query to database
    my $sth = $dbh->query($query);
}

# Insert mac localization in db
sub insertMACLocInDB {
    my ( $idMAC, $idSwitch, $port, $status, $idTimeShoot, $dbh ) = @_;

    # Evaluate nowTime
    my $nowTime = myFunctionUtils::timeNow();

    # Create query for insert
    my $query =
"INSERT INTO $DBlistLocation (idMAC, idSwitch, port, status, time, idTimeShoot) VALUES ('$idMAC','$idSwitch','$port','$status','$nowTime','$idTimeShoot')";
    myFunctionUtils::traceLog( $query, 3 );

    # query to database
    my $sth = $dbh->query($query);
}

# Update last mac localization in db
sub updateMACLocInDB {
    my ( $lastIDLoc, $status, $idTimeShoot, $dbh ) = @_;

    # Evaluate nowTime
    my $nowTime = myFunctionUtils::timeNow();

    # Create query for update
    my $query = "UPDATE $DBlistLocation SET ";
    if ( defined($status) ) {
        $query .= "status='$status', ";
    }
    $query .=
      "time='$nowTime', idTimeShoot='$idTimeShoot' WHERE id='$lastIDLoc'";
    myFunctionUtils::traceLog( $query, 3 );

    # query to database
    my $sth = $dbh->query($query);
}

# Insert timeShoot in db
sub insertTimeShoot {
    my ( $timeShoot, $dbh ) = @_;

    # Create query for insert
    my $query = "INSERT INTO $DBmalTimeShoot (timeShoot) VALUES ('$timeShoot')";
    myFunctionUtils::traceLog( $query, 3 );

    # execute query
    my $sth = $dbh->query($query);
}

# get idTimeShoot from db
sub getIDTimeShoot {
    my ( $timeShoot, $dbh ) = @_;

    # Create query for insert
    my $query = "SELECT id FROM $DBmalTimeShoot WHERE timeShoot='$timeShoot'";
    myFunctionUtils::traceLog( $query, 3 );

    # execute query
    my $sth = $dbh->query($query);

    my $idTimeShoot = $sth->fetchrow;
    return $idTimeShoot;
}

# Count how many entry for raw mac (family mac?)
sub countEntryForMAC {
    my ( $cleanedUpMAC, $dbh ) = @_;
    my $query =
      "SELECT count(*) FROM $DBlistMAC WHERE macaddress LIKE '%"
      . $cleanedUpMAC . "%'";
    myFunctionUtils::traceLog( $query, 5 );

    # execute query
    my $sth = $dbh->query($query);

    my $countEntryForMAC = $sth->fetchrow;
    return $countEntryForMAC;
}

# Count how many entry for switch's port
sub countEntryForSwitchPort {
    my ( $IP, $Port, $dbh ) = @_;
    my $query =
"SELECT count(*) FROM $DBlistLocation AS l, $DBlistSwitch AS s WHERE l.idSwitch = s.id AND s.ip='$IP' AND l.port='$Port'";
    myFunctionUtils::traceLog( $query, 5 );

    # execute query
    my $sth = $dbh->query($query);

    my $countEntryForMAC = $sth->fetchrow;
    return $countEntryForMAC;
}

# Get older entry (get older inserted datetime in db) for raw mac
sub getOlderTimeEntryForMAC {
    my ( $cleanedUpMAC, $dbh ) = @_;
    my $query =
        "SELECT inserted FROM $DBlistMAC WHERE macaddress LIKE '%"
      . $cleanedUpMAC
      . "%' ORDER BY inserted ASC LIMIT 1";
    myFunctionUtils::traceLog( $query, 5 );

    # execute query
    my $sth = $dbh->query($query);

    my $OlderTimeEntryForMAC = $sth->fetchrow;
    return myFunctionUtils::transformDatetimeInHumanDate($OlderTimeEntryForMAC);
}

# Get older/last entry (get older inserted datetime in db) for switch's IP and Port
sub getTimeEntryForSwitchPort {
    my ( $IP, $Port, $dbh, $type ) = @_;
    my $query =
"SELECT m.time FROM $DBlistLocation AS m, $DBlistSwitch AS s WHERE m.idSwitch = s.id AND s.ip='$IP' AND m.port='$Port' ORDER BY m.time";
    if ( $type eq 'last' ) {
        $query .= ' DESC';
    }
    else {
        $query .= ' ASC';
    }
    $query .= ' LIMIT 1';
    myFunctionUtils::traceLog( $query, 5 );

    # execute query
    my $sth = $dbh->query($query);

    my $TimeEntryForSwitchPort = $sth->fetchrow;
    return myFunctionUtils::transformDatetimeInHumanDate(
        $TimeEntryForSwitchPort);
}

# Get last entry (get last inserted datetime in db) for raw mac
sub getLastTimeEntryForMAC {
    my ( $cleanedUpMAC, $dbh ) = @_;
    my $query =
"SELECT loc.time FROM $DBlistLocation AS loc, $DBlistMAC AS mac WHERE mac.macaddress LIKE '%$cleanedUpMAC%' and mac.id=loc.idMAC ORDER BY loc.time DESC LIMIT 1";
    myFunctionUtils::traceLog( $query, 5 );

    # execute query
    my $sth = $dbh->query($query);

    my $LastTimeEntryForMAC = $sth->fetchrow;
    return myFunctionUtils::transformDatetimeInHumanDate($LastTimeEntryForMAC);
}

# get current MAC from raw MAC (remember: raw MAC can be a fragment mac!!)
sub getMACFromRawMAC {
    my ( $cleanedUpMAC, $dbh ) = @_;
    my $query =
"SELECT macaddress FROM $DBlistMAC WHERE macaddress LIKE '%$cleanedUpMAC%'";
    myFunctionUtils::traceLog( $query, 5 );

    # execute query
    my $sth = $dbh->query($query);

    my $correctMAC = $sth->fetchrow;
    return $correctMAC;
}

# get story of mac address
sub getMACstory {
    my ( $cleanedUpMAC, $dbh ) = @_;
    my $query =
"SELECT sw.ip AS ip, sw.description AS description, loc.port AS port, loc.time AS time FROM $DBlistLocation AS loc, $DBlistMAC AS mac, $DBlistSwitch AS sw WHERE mac.macaddress LIKE '%$cleanedUpMAC%' AND mac.id=loc.idMAC AND loc.idSwitch=sw.id ORDER BY loc.time DESC";
    myFunctionUtils::traceLog( $query, 5 );

    # execute query
    my $sth = $dbh->query($query);

    return $sth;
}

# Get list of macaddress from switch's port
sub getListMACFromSwitchPort {
    my ( $IP, $Port, $dbh ) = @_;
    my $query =
"SELECT m.macaddress AS mac, l.time AS time FROM $DBlistLocation AS l, $DBlistSwitch AS s, $DBlistMAC AS m WHERE l.idMAC=m.id AND l.idSwitch = s.id AND s.ip='$IP' AND l.port='$Port' ORDER BY l.time DESC";
    myFunctionUtils::traceLog( $query, 5 );

    # execute query
    my $sth = $dbh->query($query);

    return $sth;
}

1;
