###############################################################################
# Copyright (C) 2006, 2007 Mariano Spadaccini	mariano@marianospadaccini.it  #
#									      #
# This file is part of MacAddressLocator.                                     #
#                                                                             #
#  MacAddressLocator is free software; you can redistribute it and/or modify  #
#  it under the terms of the GNU General Public License as published by       #
#  the Free Software Foundation; either version 2 of the License, or          #
#  (at your option) any later version.                                        #
#                                                                             #
#  MacAddressLocator is distributed in the hope that it will be useful,       #
#  but WITHOUT ANY WARRANTY; without even the implied warranty of             #
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              #
#  GNU General Public License for more details.                               #
#                                                                             #
#  You should have received a copy of the GNU General Public License          #
#  along with Foobar; if not, write to the Free Software                      #
#  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA #
###############################################################################

package ParamSNMP;

use strict;
use warnings;
use Exporter;

our @ISA = qw(Exporter);
our (%EXPORT_TAGS);

$EXPORT_TAGS{'config'} =
  [qw($getCommunity $subtree $mac_list $mac_port $mac_status $parallel)];
Exporter::export_ok_tags('config');

$EXPORT_TAGS{'swFetch'} = [qw($swName $swDescr $swLocation $swMAC)];
Exporter::export_ok_tags('swFetch');

# exporter tags 'config'
our $getCommunity = '$<$getCommunity$>$';
our $subtree      = '1.3.6.1.2.1.17.4.3.1';
our $mac_list     = '1.3.6.1.2.1.17.4.3.1.1';
our $mac_port     = '1.3.6.1.2.1.17.4.3.1.2';
our $mac_status   = '1.3.6.1.2.1.17.4.3.1.3';
our $parallel     = 0;

# exporter tags 'swFetch'
our $swName     = '1.3.6.1.2.1.1.5.0';    # sysName.0
our $swDescr    = '1.3.6.1.2.1.1.1.0';    # sysDescr.0
our $swLocation = '1.3.6.1.2.1.1.6.0';    # sysLocation.0

#our $swMAC = '1.3.6.1.2.1.2.2.1.6';	# ifPhysAddress
our $swMAC = '1.3.6.1.2.1.2.2.1.6.2';     # ifPhysAddress.2

1;
