# -*- coding: utf-8 -*-
# Author:   $Author: merkosh $
# Revision: $Rev: 85 $
############################################################################
#    Copyright (C) 2005 by Uwe Mayer                                       #
#    merkosh@hadiko.de                                                     #
#                                                                          #
#    This program is free software; you can redistribute it and/or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 2 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             #
############################################################################

#-- imports --------------------------------------------------------------------
#-- Qt imports
from qt import SIGNAL, QListView, QListViewItem

#-- Python imports
import logging
import sys
import os


#-- own imports
from TitleMatchListBase import TitleMatchListBase
from Settings import getPreferences


#-- preferences ----------------------------------------------------------------
pref = getPreferences(__name__)



class TitleMatchList(TitleMatchListBase):
    """displays title matches returned by a script"""
    def __init__(self, parent=None, name=None, fl=0):
        TitleMatchListBase.__init__(self, parent, name, fl)

        self.log = logging.getLogger( self.__class__.__name__)
        self.log.setLevel(pref['logLevel'])

        # adjust presentation
        self.listViewRecord.setRootIsDecorated(True)
        self.listViewRecord.setSortColumn(-1)
        self.listViewRecord.setColumnWidthMode(1, QListView.Maximum)

        # runtime variables
        self.sectionMap = {}            # maps '<section name>' -> listViewItem
        self.recordMap = {}             # maps listViewItem -> record

        # connect slots
        self.connect(self.pushButtonViewPage, SIGNAL("pressed()"), self.onViewPage)
        self.connect(self.listViewRecord, SIGNAL("returnPressed(QListViewItem*)"), self.onReturnPressed)
        self.connect(self.listViewRecord, SIGNAL("doubleClicked(QListViewItem*)"), self.onReturnPressed)
        

    def onReturnPressed(self, obj):
        """executed when return is pressed"""
        self.accept()


    def onViewPage(self):
        """starts the browser with the selected url"""
        url = self.selectedItem()
        if (url == None):
            self.log.warning("nothing selected")
            return

        if (pref['browserPath'] == ""):
            self.log.warning("No browser specified")
            return
        
        os.spawnlp(os.P_NOWAIT, pref['browserPath'], pref['browserPath'], url)
        # no error handling possible: cannot intercept return
        # code with P_NOWAIT
        
        

    def selectedItem(self):
        """returns the selected item's url, None on rejection"""
        obj = self.listViewRecord.selectedItem()
        if ((obj == None) or (not self.recordMap.has_key(obj))):
            return None
        return self.recordMap[obj]['url']


    def add(self, rec):
        """adds a new record to the listView"""
        # this section is not available
        if (not self.sectionMap.has_key(rec['section'])):
            s = QListViewItem( self.listViewRecord, rec['section'] )
            s.setSelectable(False)
            s.setOpen(True)
            self.sectionMap[rec['section']] = s

        # section exists
        s = self.sectionMap[rec['section']]
        # make sure description field exists
        if (not rec.has_key('description')):
            rec['description'] = ""

        obj = QListViewItem( s, rec['title'], rec['description'] )
            
        self.recordMap[obj] = rec


    def parseScriptInput(self, text):
        """parses a script output and extracts record information

        Return: status value
        """
        lines = text.split("\n")
        section = "Results"
        record = None
        status = None
        for line in lines:
            if (line == ""): continue
            (field, value) = line.split(": ", 1)

            if (field == "status"):
                status = value
                if (value != "list"):
                    self.log.warning("Wrong status: %s; skipping", value)
                    return status
            elif (field == 'section'):
                section = value
            elif (field == 'title'):
                # read in record
                if (record != None): self.add(record)
                # create new record
                record = {'section': section, 'title': value}
            else:
                if (record == None):
                    self.log.warning("Record does not start with \"title\" keyword; ignoring")
                    continue
                record[field] = value
        # return true on success
        if (record != None):
            self.add(record)
            return status
        return "empty"



#-- testroutine ----------------------------------------------------------------
if (__name__ == '__main__'):
    import os
    from qt import QApplication, QObject, SLOT
    
    a = QApplication(sys.argv)
    QObject.connect(a,SIGNAL("lastWindowClosed()"),a,SLOT("quit()"))
    w = TitleMatchList()

    os.chdir("./scripts")
    fd = os.popen("./IMDB-en.pl Jumanji", "r")
    text = unicode(fd.read(), 'latin1')
    fd.close()

    print text

    w.parseScriptInput(text)

    a.setMainWidget(w)
    w.show()

    a.exec_loop()

    print "result: ",w.selectedItem()

#-- EOF --
