# -*- coding: utf-8 -*-
# Author:   $Author: merkosh $
# Revision: $Rev: 67 $
############################################################################
#    Copyright (C) 2005 by Uwe Mayer                                       #
#    merkosh@hadiko.de                                                     #
#                                                                          #
#    This program is free software; you can redistribute it and/or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 2 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             #
############################################################################

#-- imports --------------------------------------------------------------------
#-- Qt imports
from qt import QTimer, SLOT, SIGNAL, QMovie, QStringList


#-- Python imports
import logging
import os


#-- own imports
from ScriptExecutionDialogBase import ScriptExecutionDialogBase
from Settings import getPreferences


#-- preferences ----------------------------------------------------------------
pref = getPreferences(__name__)



class ScriptExecutionDialog(ScriptExecutionDialogBase):
    """executes a script and displays a dialog widget and enables to abort"""
    def __init__(self, process, parent=None, name=None, modal=False, fl=0):
        ScriptExecutionDialogBase.__init__(self, parent, name, modal, fl)

        # create logging instance
        self.log = logging.getLogger( self.__class__.__name__ )
        self.log.setLevel( pref['logLevel'] )

        self.labelGlobe.setMovie(QMovie("resources/rotatingGlobe.mng"))

        # child IO
        self.stdoutText = ""
        self.stderrText = ""

        # monitor process execution
        self.process = process
        self.connect(self.process, SIGNAL("readyReadStdout()"), self.readStdout)
        self.connect(self.process, SIGNAL("readyReadStderr()"), self.readStderr)
        self.connect(self.process, SIGNAL("processExited()"), self.accept)


    def readStdout(self):
        """reads data from processes stdout"""
        self.stdoutText += unicode(str(self.process.readStdout()), pref['systemEncoding'])


    def readStderr(self):
        self.stderrText += unicode(str(self.process.readStderr()), pref['systemEncoding'])


    def reject(self):
        """called when user aborts process"""
        self.log.info("Aborting process execution")
        self.process.tryTerminate()
        QTimer.singleShot(5000, self.process, SLOT("kill()"))
        ScriptExecutionDialogBase.reject(self)


    def exec_loop(self):
        """starts dialogs event loop"""
        cmd = unicode(self.process.arguments().join(" "))
        self.log.info("Executing: %s", cmd)
        self.textLabelStatus.setText(cmd)

        # create artificial proxy environment from config file
        env = None
        if (pref['proxy'] != None):
            env = QStringList()
            for (k,v) in pref['proxy'].iteritems():
                env.append('%s_proxy=%s'%(k,v))

        # execute
        if (not self.process.start(QStringList(env))):
            self.log.error("Could not start command execution")
            return self.Rejected
        ret = ScriptExecutionDialogBase.exec_loop(self)
        self.textLabelStatus.setText(self.tr("Done."))
        return ret


    def stdout(self):
        """returns child's stdout text"""
        return self.stdoutText


    def stderr(self):
        """returns child's stderr text"""
        return self.stderrText


#-- testarea -------------------------------------------------------------------
if (__name__ == '__main__'):
    import sys
    from qt import QApplication, QDialog, QProcess, QStringList
    
    a = QApplication(sys.argv)

    # need logging handlers for testing
    log = logging.getLogger("")
    hdlr = logging.StreamHandler()
    formatter = logging.Formatter('[%(name)s] %(levelname)s: %(message)s')
    hdlr.setFormatter(formatter)
    log.addHandler(hdlr) 
    log.setLevel(pref['logLevel'])

    cmd = "scripts/filmposterarchiv-de.pl \"Harry Potter and the Sorcerer's Stone\""
    script = QProcess("scripts/filmposterarchiv-de.pl")
    script.addArgument("Harry Potter and the Sorcerer's Stone")

    w = ScriptExecutionDialog(script)
    
    print "aborted: ",w.exec_loop() == QDialog.Rejected
    print w.stdoutText

