group simple_pdf;

main(records) ::= <<
%% -*- coding: latin-1 -*-
\documentclass[8pt,oneside,a4paper]{book}
\usepackage[english]{babel}    % trennung, sprache
\usepackage[T1]{fontenc}
%\usepackage{ucs}              % codierung
\usepackage[latin1]{inputenc}
\usepackage{longtable}
\usepackage{colortbl}

%-- ifPDF statement
% condition wether compiling with pdflatex or not
% usage: \ifPDF <then> \else <else> \fi
\newif\ifPDF
\ifx\pdfoutput\undefined\PDFfalse
\else\ifnum\pdfoutput > 0\PDFtrue
     \else\PDFfalse
     \fi
\fi

\ifPDF
\usepackage{aeguill}          % font (pdflatex, breaks whizzytex)
%\usepackage[pdftex]{color}    % text color
\usepackage[pdftex]{graphicx} % graphics
\usepackage[unicode,pdftex]{hyperref} % links in pdf 
\hypersetup{colorlinks=false,%
  unicode=true,%
  pdfauthor={Uwe Mayer},%
  pdftitle={Methoden zur Visualisierung und Evaluierung
            von Lerninteraktion im fallbasierten
            Lernsystem Soon--Player},%
  }

\else
%\usepackage[dvips]{color}     % font color
\usepackage[dvips]{graphicx}  % graphics
\usepackage[dvips]{hyperref}  % links in pdf 
\fi


%% -----------------------------------------------------------------------------
\setlength{\parindent}{0pt}
\setlength{\parskip}{1.3ex plus 0.5ex minus 0.2ex}
\setlength{\hoffset}{-2.5cm}

\pagestyle{plain}

%% -- main document ------------------------------------------------------------
\begin{document}

\small

\begin{longtable}{|l|p{6cm}|p{2.5cm}|p{3cm}|l|l|}

No & Title & Language & Genre & Resolution & Location \\
\hline
\endhead

$records:formatListWhite(rec),formatListGray(rec)$

\end{longtable}

\end{document}
>>


formatListWhite(rec) ::= <<
$i$. & $rec.mediaLabel$ & 
$rec.languages$ & $rec.category$ & $rec.resolution$ & $rec.source$ \\

>>

formatListGray(rec) ::= <<
\rowcolor[gray]{.8}
$i$. & $rec.mediaLabel$ & 
$rec.languages$ & $rec.category$ & $rec.resolution$ & $rec.source$ \\

>>


formatPicture(rec) ::= <<
\includegraphics[width=1.5cm]{$rec.picture$}
>>
