#!/usr/bin/perl -w
# Author:   $Author: merkosh $
# Revision: $Rev: 755 $
############################################################################
#    Copyright (C) 2005 by Uwe Mayer                                       #
#    merkosh@hadiko.de                                                     #
#                                                                          #
#    This program is free software; you can redistribute it and/or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 2 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          #
############################################################################

#-------------------------------------------------------------------------#
# scan filmposter-archiv.de for a number of fields on a movie title       #
#-------------------------------------------------------------------------#

#-- imports --------------------------------------------------------------------
use URI::Escape;
use LWP::UserAgent;
use HTTP::Request;
use HTML::Entities;
use File::Basename;

use LMCTools;


#-- display help screen --------------------------------------------------------
if ((grep /--help|-h/,@ARGV) || (scalar @ARGV == 0)) {
  print STDERR <<HELP;
filmposterarchiv-de.pl  \$Rev\$  (c)  2005-01-11  by Uwe Mayer

Search filmposter-archiv.de for picture on a movie title

Synopsis: filmposterarchiv-de.pl [-h|--help] <title>|<URL>

     -h     --help     this screen
     <title>           search for <title> on filmposter-archiv.de and
                       return either the information or a list of matches
     <URL>             get picture from this URL

The URL is distinguished from the title by the prefix \'http://\'. If
your title happens to have this prefix you\'re busted. ;)

If your internet connection needs a proxy server set the environment
variable "http_proxy" to the appropriate url 
(i.e. http_proxy=http://proxy.somehost.com:8080)

HELP
  exit();

}


#-- parse arguments ------------------------------------------------------------
my $title = "";
my $URL = "";

if (substr($ARGV[0], 0,7) eq 'http://') {
  $URL = $ARGV[0];
} else {
  $title = $ARGV[0];
}


#-- scan filmposter-archiv -----------------------------------------------------
$baseURL = 'http://filmposter-archiv.de/html/';
$searchURL = $baseURL.'suche.php3?sent=1&filmtitel=';


#-- title ----------------------------------------------------------------------
if ($title) {
  #-- defaults
  @sections = ("Pictures:");
  %match = ();
  $totalResults = 0;
  $count = 0;

  #-- get list of titles
  # german search
  $page = getPage($searchURL.uri_escape($title))->content();
  # get number of matches
  $count = $1 if ($page =~ /ergab \<b\>(\d+) Treffer/i);

#   # english failsafe
#   if ($count == 0){
#     $page = getPage($searchURL.uri_escape($title)."&language=english")->content();
#     # get number of matches
#     $count = $1 if ($page =~ /ergibt \<b\>(\d+) Treffer/i);
#   }

  for ($i=0; $i < $count; $i++){
    $page = &find($page, "<LI><A HREF=");

    if ($page =~ /href\=\"(anzeige.php3\?id\=\d+)\".+?\>(.+?)\<\/a/i) {
      my %entry = (URL => $baseURL.$1, Text => $2);
      # description available
      $tmp_start = index($page, "<A HREF=\"anzeige_gr.php3");
      if (($tmp_start != -1) && ($tmp_start < index($page, "</LI>"))){
	$page = &find($page, "<A HREF=\"anzeige_gr.php3", 1);
	$page = &find($page, "</A>", 1);
	$entry{Comment} = &strip(decode_entities($1)) if ($page =~ /\<\/a\>(.+?)\<\/li\>/i);
      }

      push @{$match{$sections[0]}}, \%entry;
      $totalResults++;
    }
  }


  #-- output Results
  if ($totalResults == 0){
    # cannot write error message here, or lmc will abort
    #print STDERR "No matches found on \"$title\"\n";
  } else {
    print "status: list\n";

    foreach $sec (@sections){
      print "section: $sec\n";

      foreach $rec (@{$match{$sec}}){
	print "title: $rec->{Text}\n";
	print "url: $rec->{URL}\n";
	print "description: $rec->{Comment}\n";
	print "\n";
      }
    }
  }

  exit();
}

#-- URL ------------------------------------------------------------------------
if ($URL){
  #-- get main page
  $response = getPage($URL);
  $page = $response->content();
  # when querying for a list and recieving details the url
  # of the page has changed: update this
  $URL = $response->base();

  # fields we are looking out for:
  %data = ();
  # - picture

  # the following are not available
  # - originalTitle
  # - year
  # - director
  # - category
  # - actors
  # - rating
  # - url
  # - length
  # - country
  # - language
  # - description
  # - comments
  # - translatedTitle
  # - producer

  # picture
  $tmp = &find($page, '<IMG SRC="../filmplakat/', 1);

  if ($tmp =~ /src\=\"(.+?)\"/i) {
    $imageURL = $baseURL.$1;
#     $imageURL =~ /(\..{0,3})$/;
#     $suffix = $1;
#     $count = 0;
#     do {
#       $tempfile = sprintf "/tmp/temp_%05d%s", $count++, $suffix;
#     } while (-e $tempfile);
#     open FILE, ">$tempfile";
#     print FILE getPage($imageURL)->content();
#     close FILE;
#     $data{picture} = $tempfile;
    $data{picture} = $imageURL;
  }

  #-- output
  print "status: details\n";

  foreach $k (keys(%data)){
    if ($k =~ /description|actors/){
      foreach (@{$data{$k}}){
	print "$k: $_\n";
      }
    }
    else {
      print "$k: $data{$k}\n";
    }
    print "\n";
  }


}
