# -*- coding: utf-8 -*-
# Author:   $Author: merkosh $
# Revision: $Rev: 770 $
############################################################################
#    Copyright (C) 2005 by Uwe Mayer                                       #
#    merkosh@hadiko.de                                                     #
#                                                                          #
#    This program is free software; you can redistribute it and/or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 2 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          #
############################################################################

#-- imports --------------------------------------------------------------------
#-- Qt imports
from qt import QTimer, SIGNAL, QStringList, QProcess, QDir


#-- Python imports
import logging


#-- own imports
from Settings import getPreferences


#-- preferences ----------------------------------------------------------------
pref = getPreferences(__name__)


class StdIOProcess(QProcess):
    def __init__(self, name, args=[], env=None, workingDirectory="."):
        QProcess.__init__(self, name)
        
        # create logging
        self.log = logging.getLogger(self.__class__.__name__)
        self.log.setLevel(pref['logLevel'])
        
        # child IO
        self.stdoutText = ""
        self.stderrText = ""

        # process execution
        self.setWorkingDirectory(QDir(workingDirectory))
        
        for arg in args:
            self.addArgument(arg)
            
        # environment variables
        self.env = None
        if (env != None):
            self.env = QStringList()
            for (k,v) in env.iteritems():
                self.env.append('%s=%s'%(k,v))

        # capture stdio and emit processExited() signal on completion
        self.connect(self, SIGNAL("readyReadStdout()"), self.readStdout)
        self.connect(self, SIGNAL("readyReadStderr()"), self.readStderr)
        

    #-- QProcess interface
    def start(self):
        """starts execution of process (in background)"""
        return QProcess.start(self, self.env)


#     def launch(self, text):
#         """starts execution (in background), passing text to stdin"""
#         return QProcess.launch(self, text, self.env)
    

    #-- extended interface
    def stdout(self):
        """returns child's stdout text"""
        return self.stdoutText


    def stderr(self):
        """returns child's stderr text"""
        return self.stderrText


    #-- signal handler
    def readStdout(self):
        """reads data from processes stdout"""
        self.stdoutText += unicode(str(QProcess.readStdout(self)), pref['systemEncoding'])


    def readStderr(self):
        self.stderrText += unicode(str(QProcess.readStderr(self)), pref['systemEncoding'])



#-- testarea -------------------------------------------------------------------
if (__name__ == "__main__"):
    pass
