# -*- coding: utf-8 -*-
# Author:   $Author: merkosh $
# Revision: $Rev: 692 $
############################################################################
#    Copyright (C) 2005 by Uwe Mayer                                       #
#    merkosh@hadiko.de                                                     #
#                                                                          #
#    This program is free software; you can redistribute it and/or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 2 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          #
############################################################################

#-- imports --------------------------------------------------------------------
#-- Qt imports
from qt import QListView, QListViewItem, SIGNAL

#-- Python imports
import logging


#-- own imports
from ScriptSelectionBase import ScriptSelectionBase
from Settings import getPreferences


#-- preferences ----------------------------------------------------------------
pref = getPreferences(__name__)



class ScriptSelection(ScriptSelectionBase):
    """allows choosing a script to execute"""
    def __init__(self, parent=None, name=None, modal=False, fl=0):
        ScriptSelectionBase.__init__(self, parent, name, modal, fl)

        # create logging
        self.log = logging.getLogger( self.__class__.__name__ )
        self.log.setLevel(pref['logLevel'])

        # customisations
        self.listViewRecord.setColumnWidthMode(1, QListView.Maximum)
        self.listViewRecord.setRootIsDecorated(True)
        self.listViewRecord.setAllColumnsShowFocus(True)
        self.listViewRecord.setSortColumn(0)

        # runtime variables
        self.items = {}                 # maps ListViewItem -> script-key

        # display scripts
        defaultScript = None
        for group in pref['scripts']:
            item = QListViewItem(self.listViewRecord, group)
            item.setText(1, pref['scripts'][group][0])
            item.setMultiLinesEnabled(True)

            # remember default selected script
            if (pref['defaultScript'] == group):
                defaultScript = item

            self.items[item] = pref['scripts'][group][1] # remember list of scripts to execute

            after = None
            for line in pref['scripts'][group][1]:
                subitem = QListViewItem(item, after)
                subitem.setText(0, line[0])
                subitem.setText(1, ", ".join(line[1:]))
                subitem.setSelectable(False)
                after = subitem

        # select first child by default
        if (defaultScript == None): defaultScript = self.listViewRecord.fistChild()
        self.listViewRecord.setSelected(defaultScript, True)


        # connect slots
        self.connect(self.listViewRecord, SIGNAL("returnPressed(QListViewItem*)"), self.onReturnPressed)
        self.connect(self.listViewRecord, SIGNAL("doubleClicked(QListViewItem*)"), self.onReturnPressed)


    def onReturnPressed(self, obj):
        """executed when enter is pressed"""
        self.accept()
        
                
    def selectedItem(self):
        """returns the selected item's list of scripts to execute"""
        obj = self.listViewRecord.selectedItem()
        if (obj == None): return None
        return self.items[obj]
        


#-- testarea -------------------------------------------------------------------
if (__name__ == '__main__'):
    import sys
    from qt import QApplication, QObject, SIGNAL, SLOT
    
    a = QApplication(sys.argv)
    QObject.connect(a,SIGNAL("lastWindowClosed()"),a,SLOT("quit()"))

    w = ScriptSelection()
#    a.exec_loop()

    if (w.exec_loop() == w.Accepted):
        print w.selectedItem()


#-- EOF --
