# -*- coding: utf-8 -*-
# Author:   $Author: merkosh $
# Revision: $Rev: 770 $
############################################################################
#    Copyright (C) 2005 by Uwe Mayer                                       #
#    merkosh@hadiko.de                                                     #
#                                                                          #
#    This program is free software; you can redistribute it and/or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 2 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          #
############################################################################

#-- imports --------------------------------------------------------------------
#-- Qt imports
from qt import QTimer, SLOT, SIGNAL, QMovie
from qt import PYSIGNAL


#-- Python imports
import logging
import os

from os.path import join as fjoin


#-- own imports
from ExportProgressDialogBase import ExportProgressDialogBase
from defaults import resourcedir
from Settings import getPreferences


#-- preferences ----------------------------------------------------------------
pref = getPreferences(__name__)



class ExportProgressDialog(ExportProgressDialogBase):
    """displays and handles export progress dialog"""
    def __init__(self, generatorScript, paramList, outputFilename, filterScript, parent=None, name=None, modal=False, fl=0):
        ExportProgressDialogBase.__init__(self, parent, name, modal, fl)

        # create logging
        self.log = logging.getLogger( self.__class__.__name__ )
        self.log.setLevel( pref['logLevel'] )

        # customisations
        self.labelPrinter.setMovie(QMovie(fjoin(resourcedir, "printer.mng")))

        # runtime variable
        self.generatorScript  = generatorScript
        self.paramList        = paramList
        self.outputFilename   = outputFilename
        self.filterScript     = filterScript

        # connect signals
        self.connect(self.generatorScript, SIGNAL("wroteToStdin()"), self.generatorScriptCloseStdin)
        self.connect(self.generatorScript, SIGNAL("processExited()"), self.generatorScriptExited)
        self.connect(self.filterScript, SIGNAL("processExited()"), self.filterScriptExited)


    def generatorScriptCloseStdin(self):
        """called when generatorScript has taken all its input"""
        self.generatorScript.closeStdin()


    def generatorScriptExited(self):
        """called when generatorScript outputed its result"""
        # save text to ouptut file
        stdout_text = self.generatorScript.stdout()
        stderr_text = self.generatorScript.stderr()
        if (stderr_text != ''):
            self.log.error("Error executing templateParser.py: %s", stderr_text)
            self.reject()
        
        open(self.outputFilename, 'w').write(stdout_text.encode(pref['systemEncoding']))

        # execute filter chain
        self.log.info("Executing filter chain...")
        self.log.debug(" ".join((unicode(x) for x in self.filterScript.arguments())))
        self.textLabelStatus.setText("2. Executing filter chain...")

        if (not self.filterScript.start()):
            self.log.error("Could not start filter script; aborting")
            self.reject()


    def filterScriptExited(self):
        """called when filter script terminates"""
        stdout_text = self.filterScript.stdout()
        stderr_text = self.filterScript.stderr()
        if (stderr_text != ''):
            self.log.error("Error executing filter chain: %s", stderr_text)
            self.reject()
        
        self.accept()


    def reject(self):
        """called when user aborts process"""
        self.log.info("Aborting export")
        ExportProgressDialogBase.reject(self)


    def exec_loop(self):
        """starts dialogs event loop"""
        self.log.info("Parsing template...")
        self.log.debug(" ".join((unicode(x) for x in self.generatorScript.arguments())))
        self.textLabelStatus.setText("1. Parsing template...")

        # execute generator script
        text = "\n".join(self.paramList)
        if (not self.generatorScript.start()):
            self.log.error("Could not process template; aborting")
            self.reject()

        # write parameter to generatorScript
        self.generatorScript.writeToStdin(text)

        # execution continues at waitGeneratorScript
        return ExportProgressDialogBase.exec_loop(self)

        
        

if (__name__ == '__main__'):
    from qt import QApplication

    import time
    import sys
    
    a = QApplication(sys.argv)

    
