# -*- coding: utf-8 -*-
# Author:   $Author: merkosh $
# Revision: $Rev: 766 $
############################################################################
#    Copyright (C) 2005 by Uwe Mayer                                       #
#    merkosh@hadiko.de                                                     #
#                                                                          #
#    This program is free software; you can redistribute it and/or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 2 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          #
############################################################################

#-- imports --------------------------------------------------------------------
#-- Qt imports
from qt import QTimer, SLOT, SIGNAL, QMovie
from qt import PYSIGNAL


#-- Python imports
import logging
import os

from os.path import join as fjoin


#-- own imports
from ExportProgressDialogBase import ExportProgressDialogBase
from defaults import resourcedir
from Settings import getPreferences


#-- preferences ----------------------------------------------------------------
pref = getPreferences(__name__)



class ExportProgressDialog(ExportProgressDialogBase):
    """displays and handles export progress dialog"""
    def __init__(self, process, sortList, parent=None, name=None, modal=False, fl=0):
        ExportProgressDialogBase.__init__(self, parent, name, modal, fl)

        # create logging
        self.log = logging.getLogger( self.__class__.__name__ )
        self.log.setLevel( pref['logLevel'] )

        # customisations
        self.labelPrinter.setMovie(QMovie(fjoin(resourcedir, "printer.mng")))

        # runtime variable
        self.process = process
        self.sortList = sortList

        # connect signals
        self.connect(self.process, SIGNAL("wroteToStdin()"), self.closeStdin)
        self.connect(self.process, SIGNAL("processExited()"), self.accept)


    def closeStdin(self):
        self.process.closeStdin()


    def reject(self):
        """called when user aborts process"""
        self.log.info("Aborting export")
        self.process.tryTerminate()
        QTimer.singleShot(5000, self.process, SLOT("kill()"))
        ExportProgressDialogBase.reject(self)


    def exec_loop(self):
        """starts dialogs event loop"""
        # shorten command line parameters
        args = [unicode(self.process.arguments()[0])]
        for k in self.process.arguments()[1:]:
            if (len(k) > 15+3):
                args.append("..."+unicode(k[-15:]))
            else:
                args.append(unicode(k))

        cmd = unicode(" ".join(args))
        self.log.info("Executing: %s", cmd)
        self.textLabelStatus.setText(cmd)

        # execute
        if (not self.process.start()):
            self.log.error("Could not start command execution")
            return self.Rejected

        # write data to stdin
        text = "\n".join(self.sortList)
        self.process.writeToStdin( text+"\n" )
        
        return ExportProgressDialogBase.exec_loop(self)
        
        

if (__name__ == '__main__'):
    from qt import QApplication

    import time
    import sys
    
    a = QApplication(sys.argv)

    
