# Author:   $Author: merkosh $
# Revision: $Rev: 692 $
############################################################################
#    Copyright (C) 2005 by Uwe Mayer                                       #
#    merkosh@hadiko.de                                                     #
#                                                                          #
#    This program is free software; you can redistribute it and/or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 2 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          #
############################################################################

#--------------------------------------------------------------------#
# Provides some functions which are used by the default              #
# LMC script set                                                     #
#--------------------------------------------------------------------#

package LMCTools;
use Exporter;
@ISA = ('Exporter');

@EXPORT = qw(find strip getPage);


#--
# given a search text and a match (optional starting position)
# it searches the first index of the text that matches the substring
# and returns the text, starting from the substring position
# if no match found: returns the empty string
sub find($$;$){
  my $pos = 0;
  my ($text, $match) = @_;
  $pos = $_[2] if ($#_ >= 2);

  $pos = index($text, $match, $pos);
  return "" if ($pos == -1);
  return substr($text, $pos);
}


#--
# strips tailing and leading white-characters from a string
sub strip($){
  $text = $_[0];
  $text =~ s/^\s*//;
  $text =~ s/\s*$//;
  return $text;
}


#--
# given a URL it retrieves the HTML page
# on error it exits with error code and URL
sub getPage($) {
  my $ua = new LWP::UserAgent();
  $ua->proxy("http", $ENV{http_proxy}) if (exists $ENV{http_proxy});

  my $url = $_[0];
  my $req = new HTTP::Request(GET, $url);
  my $resp = $ua->request($req);

  if ($resp->is_error()){
    print "status: error\n";
    print STDERR "url: $url\n";
    print STDERR $resp->message();
    exit();
  }

  return $resp;
}

