#!/usr/bin/perl -w
# Author:   $Author: merkosh $
# Revision: $Rev: 759 $
############################################################################
#    Copyright (C) 2005 by Uwe Mayer                                       #
#    merkosh@hadiko.de                                                     #
#                                                                          #
#    This program is free software; you can redistribute it and/or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 2 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          #
############################################################################

#---------------------------------------------------------#
# scan IMDB for a number of fields on a movie title       #
#---------------------------------------------------------#

#-- imports --------------------------------------------------------------------
use URI::Escape;
use LWP::UserAgent;
use HTTP::Request;
use HTML::Entities;
use File::Basename;
use POSIX qw(ceil);

use LMCTools;

#-- display help screen --------------------------------------------------------
if ((grep /--help|-h/,@ARGV) || (scalar @ARGV == 0)) {
  print STDERR <<HELP;
IMDB-en.pl  \$Rev\$  (c)  2005-01-04  by Uwe Mayer

Search us.imdb.com for descriptive information on a movie title.

Synopsis: IMDB-en.pl [-h|--help] <title>|<URL>

     -h     --help     this screen
     <title>           search for <title> on imdb and return either the
                       the information or a list of matches
     <URL>             get information from this URL

The URL is distinguished from the title by the prefix \'http://\'. If
your title happens to have this prefix you\'re busted. ;)

If your internet connection needs a proxy server set the environment
variable "http_proxy" to the appropriate url 
(i.e. http_proxy=http://proxy.somehost.com:8080)

HELP
  exit();

}


#-- helper functions -----------------------------------------------------------

#--
# given a comment line it returns a list of propperly formated "aka <name>" strings
sub unfiddleAka($){
  my $text = $_[0];
  my $pos = 0;
  my @result = ();
  while ($pos != -1){
    $pos = index($text, "aka <em>");
    last if ($pos == -1);
    $text = substr($text, $pos+1);
    $text =~ /\"(.+?)\"\</;
    push @result, "aka $1";
  }
  return \@result;
}



#-- parse arguments ------------------------------------------------------------
my $title = "";
my $URL = "";

if (substr($ARGV[0], 0,7) eq 'http://') {
  $URL = $ARGV[0];
} else {
  $title = $ARGV[0];
}


#-- scan imdb ------------------------------------------------------------------
$baseURL = 'http://us.imdb.com';
$searchURL = 'http://us.imdb.com/Tsearch?title=';


#-- title ----------------------------------------------------------------------
if ($title) {
  #-- get list of titles
  $page = getPage($searchURL.uri_escape($title))->content();

  @sections = ("Titles (Exact Matches)", "Popular Titles", 
	       "Titles (Partial Matches)", "Titles (Approx Matches)");
  %match = ();
  $totalResults = 0;
  $pos = 0;

  #-- parse search (possible) section
  foreach $sec (@sections){
    $match{$sec} = [];
    $text = $page;
    $pos = index($text, $sec, $pos);
    if ($pos != -1) {
      $text = substr($text, $pos);
      $text =~ /Displaying (\d+) Result/;
      $count = $1;
      for ($i=0; $i < $count; $i++){
	$pos = index($text, "href=\"/title/");
	$text = substr($text, $pos);
# changed: 2007-08-04 
# 	$text =~ /href\=\"(\/title\/.+?\/)\?.+?\"\>(.+?)\<\/a\> +(\(.+?\))(.*?)\<\/td\>/;
	$text =~ /href\=\"(\/title\/.+?\/)\"\>(.+?)\<\/a\> +(\(.+?\))\</;

# changed: 2007-08-04 
# 	push @{$match{$sec}}, {URL => $1, Text => decode_entities("$2 $3"), 
# 			       Comment => &unfiddleAka(decode_entities($4))};
	push @{$match{$sec}}, {URL => $1, Text => decode_entities("$2 $3")};
	$totalResults++;

	$text = substr($text, 1);
      }
    }
  }


  #-- output Results
  if ($totalResults == 0){
    # try to interpret page as page with details
    $URL = $searchURL.uri_escape($title);
  } else {
    print "status: list\n";

    foreach $sec (@sections){
      print "section: $sec\n";

      foreach $rec (@{$match{$sec}}){
	print "title: $rec->{Text}\n";
	print "url: $baseURL$rec->{URL}\n";
# changed: 2007-08-04 
# 	foreach $desc (@{$rec->{Comment}}){
# 	  print "description: $desc\n";
# 	}
	print "\n";
      }
    }
    exit();
  }
}


#-- URL ------------------------------------------------------------------------
if ($URL){
  #-- get main page
  $response = getPage($URL);
  $page = $response->content();
  # when querying for a list and recieving details the url
  # of the page has changed: update this
  $URL = $response->base();

  # fields we are looking out for:
  %data = ();
  # - originalTitle
  # - year
  # - picture
  # - director
  # - category
  # - actors
  # - rating
  # - url
  # - length
  # - country
  # - language
  # - description
  # - comments

  # the following are not available
  # - translated title
  # - producer

  # original title
  $tmp = &find($page, '<h1>');
  $data{'originalTitle'} = decode_entities($1) if ($tmp =~ /\>([^\<]+) *\</);

  # year
  $tmp = &find($tmp, '<span>');
  $data{year} = $1 if ($tmp =~ /href\=.+?\>(\d+)\</);

  # picture
  $tmp = &find($page, '<a name="poster"');
  # if image found
  if ($tmp){
    $tmp =~ /src=\"(.+?)\"/;
    $imageURL = $1;
    $imageURL =~ /(\..{0,3})$/;
    $suffix = $1;
    $count = 0;
    do {
      $tempfile = sprintf "/tmp/temp_%05d%s", $count++, $suffix;
    } while (-e $tempfile);
    open FILE, ">$tempfile";
    print FILE getPage($imageURL)->content();
    close FILE;
    $data{picture} = $tempfile;
  }

  # director
  $tmp = &find($page, '<h5>Director');
  @director = ();
  if ($tmp) {
    do {
      $tmp =~ /href\=.+?\>([^\<]+?)\</;
      push @director, decode_entities($1);
      $tmp = &find($tmp, $1);
    } while (index($tmp, "<a href=") < index($tmp, "</div>"));

    $data{director} = join(", ", @director) if (scalar @director);
  }

  # category
  $tmp = &find($page, '<h5>Genre:');
  @category = ();
  if ($tmp) {
    do {
      $tmp =~ /href\=.+?\>([^\<]+?)\</;
      push @category, decode_entities($1);
      $tmp = &find($tmp, $1);
    } while (index($tmp, "<a href=") < index($tmp, "</div>"));
    
    $data{category} = join(", ", @category) if (scalar @category);
  }
      
  # actors
  $tmp = &find($page, 'header_cast.gif');
  @actors = ();
  do {
    $tmp = &find($tmp, '<a href="/name/', 1);
    $tmp =~ /\>(.+?)\<.+?\<td class\=\"char\"\>(.+?)\<\//;
    push @actors, decode_entities($1)." - ".decode_entities($2);
    $tmp = &find($tmp, $1);
  } while (index($tmp, "<a href=") < index($tmp, "</div>"));
  $data{actors} = \@actors if (scalar @actors);

  # rating
  $tmp = &find($page, '<b>User Rating:</b>');
  # if no rating available (first 100 char contain magic text)
  if (substr($tmp, 0, 100) !~ /awaiting \d votes/) {
    $tmp = &find($tmp, '<b>');
    $data{rating} = ceil($1) if ($tmp =~ /([\d\.]+?)\//);
  }

  # url
  $URL =~ /^(.+?\/title\/.+?\/)/;
  $URL = $1 if ($1);
  $data{url} = $URL;

  # length
  $tmp = &find($page, '<h5>Runtime:</h5>');
  $data{length} = $1 if ($tmp =~ /(\d+) min/);

  # country
  $tmp = &find($page, '<h5>Country:</h5>');
  @country = ();
  do {
    $tmp =~ /href\=\".+?\"\>(.+?)\</;
    push @country, decode_entities($1);
    $tmp = &find($tmp, $1);
  } while (index($tmp, "<a href=") < index($tmp, "</div>"));
  $data{country} = join(", ", @country) if (scalar @country);

  # language
  $tmp = &find($page, '<h5>Language:</h5>');
  @languages = ();
  do {
    $tmp =~ /href\=\".+?\"\>(.+?)\</;
    push @languages, decode_entities($1);
    $tmp = &find($tmp, $1);
  } while (index($tmp, "<a href=") < index($tmp, "</div>"));
  $data{languages} = join(", ", @languages) if (scalar @languages);

  # description
  $tmp = &getPage($URL.'plotsummary')->content();
  @summary = ();
  do {
    $tmp = &find($tmp, '<p class="plotpar">', 1);
    if ($tmp) {
      $tmp =~ /\>(.+?)\<\/p\>/s;
      push @summary, &strip(decode_entities($1));
      $summary[-1] =~ s/\<a href\=.+?\>//;
      $summary[-1] =~ s/\<\/a\>//;
      $summary[-1] =~ s/\<i\>//;
      $summary[-1] =~ s/\<\/i\>//;
      $summary[-1] =~ s/\n+/\n/;
      $summary[-1] =~ s/\n/<br>/g;
      $tmp = substr($tmp,1);
    }
  } while (index($tmp, '<p class="plotpar">') < index($tmp, '<div '));
  $data{description} = \@summary if (scalar @summary);

  # comments
  $tmp = &find($page, '<div class="comment">');
  $tmp = &find($tmp, 'Author:');
  $tmp = &find($tmp, '<p>');
  $tmp =~ /\>(.+?)\<\/p\>/s;
  if ($1) {
      $data{comments} = &strip(decode_entities($1));
      $data{comments} =~ s/\n/<br>/g;
  }


  #-- output
  # nothing found
  exit if ((scalar keys(%data) == 1) && (exists $data{url}));

  # return normal status
  print "status: details\n";

  foreach $k (keys(%data)){
    if ($k =~ /description|actors/){
      foreach (@{$data{$k}}){
	print "$k: $_\n";
      }
    }
    else {
      print "$k: $data{$k}\n";
    }
    print "\n";
  }


}
