# -*- coding: utf-8 -*-
# Author:   $Author: merkosh $
# Revision: $Rev: 692 $
############################################################################
#    Copyright (C) 2005 by Uwe Mayer                                       #
#    merkosh@hadiko.de                                                     #
#                                                                          #
#    This program is free software; you can redistribute it and/or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 2 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          #
############################################################################

#-- imports --------------------------------------------------------------------
#-- Qt imports
from qt import SIGNAL, PYSIGNAL, QStringList


#-- Python imports
import logging


#-- own imports
from ExportDialogBase import ExportDialogBase
from Settings import getPreferences

#-- preferences ----------------------------------------------------------------
pref = getPreferences(__name__)



class ExportDialog(ExportDialogBase):
    """displays the export-dialog"""
    def __init__(self, parent=None, name=None, modal=False, fl=0):
        ExportDialogBase.__init__(self, parent, name, modal, fl)

        # create logging instance
        self.log = logging.getLogger( self.__class__.__name__ )
        self.log.setLevel( pref['logLevel'] )

        # gather available scripts

        # connect signals


#-- testarea -------------------------------------------------------------------
if (__name__ == '__main__'):
    import sys
    from qt import QApplication, QDialog

    a = QApplication(sys.argv)

    # need logging handlers for testing
    log = logging.getLogger("")
    hdlr = logging.StreamHandler()
    formatter = logging.Formatter('[%(name)s] %(levelname)s: %(message)s')
    hdlr.setFormatter(formatter)
    log.addHandler(hdlr) 
    log.setLevel(pref['logLevel'])
        
    w = ExportDialog()
    print w.exec_loop()

    
