# -*- coding: utf-8 -*-
# Author:   $Author: merkosh $
# Revision: $Rev: 692 $
############################################################################
#    Copyright (C) 2005 by Uwe Mayer                                       #
#    merkosh@hadiko.de                                                     #
#                                                                          #
#    This program is free software; you can redistribute it and/or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 2 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          #
############################################################################

class ILMCFile(dict):
    """LMC file interface"""
    def __init__(self):
        dict.__init__(self)
    
    #-- file interface
    def close(self): raise NotImplementedError()
    def flush(self): raise NotImplementedError()
    def __iter__(self): raise NotImplementedError()
    def read(self): raise NotImplementedError()
    def seek(self): raise NotImplementedError()
    def tell(self): raise NotImplementedError()
    def truncate(self): raise NotImplementedError()
    def write(self): raise NotImplementedError()
    def writelines(self): raise NotImplementedError()

    #-- additional functions
    def isEOF(self): raise NotImplementedError()
    def filesize(self): raise NotImplementedError()
    def filelength(self): raise NotImplementedError()


class IDict(object):
    """dictionary interface"""
    def keys(self): raise NotImplementedError() # D.keys() -> list of D's keys
    def values(self): raise NotImplementedError() # D.values() -> list of D's values
    def items(self): raise NotImplementedError() # D.items() -> list of D's (key, value) pairs, as 2-tuples
    def has_key(self, k): raise NotImplementedError() # True if D has a key k, else False
    def get(self, k,d=None): raise NotImplementedError() # D.get(k[,d]) -> D[k] if k in D, else d.  d defaults to None.
    def clear(self): raise NotImplementedError() # D.clear() -> None.  Remove all items from D.
    def setdefault(self, k,d=None): raise NotImplementedError() # D.setdefault(k[,d]) -> D.get(k,d), also set D[k]=d if k not in D
    def iterkeys(self): raise NotImplementedError() # D.iterkeys() -> an iterator over the keys of D
    def itervalues(self): raise NotImplementedError() # D.itervalues() -> an iterator over the values of D
    def iteritems(self): raise NotImplementedError() # D.iteritems() -> an iterator over the (key, value) items of D
    def popitem(self): raise NotImplementedError() # D.popitem() -> (k, v), remove and return some (key, value) pair as a 2-tuple
    def copy(self): raise NotImplementedError() # D.copy() -> a shallow copy of D
    def update(self, E): raise NotImplementedError() # D.update(E) -> None.  Update D from E: for k in E.keys(): D[k] = E[k]
    def pop(self, k,d=None): raise NotImplementedError() # D.pop(k[,d]) -> v, remove specified key and return the corresponding value

    def __iter__(self): raise NotImplementedError() # x.__iter__() <==> iter(x)
    def next(self): raise NotImplementedError() # returns the next item from the container or raises StopIteration
    def __contains__(self, y): raise NotImplementedError() # x.__contains__(y) <==> y in x
    def __delitem__(self, y): raise NotImplementedError() # x.__delitem__(y) <==> del x[y]
    def __getitem__(self, y): raise NotImplementedError() # x.__getitem__(y) <==> x[y]
    def __setitem__(self, i,y): raise NotImplementedError() # x.__setitem__(i, y) <==> x[i]=y
    def __len__(self): raise NotImplementedError() # x.__len__() <==> len(x)


class ILMCRecord(IDict):
    """LMC record interface"""
    def modified(self, changed=None): raise NotImplementedError()


#-- EOF --
