// -*- coding: utf-8 -*-
// Author:   $Author: merkosh $
// Revision: $Rev: 140 $
// ############################################################################
// #    Copyright (C) 2005 by Uwe Mayer                                       #
// #    merkosh@hadiko.de                                                     #
// #                                                                          #
// #    This program is free software; you can redistribute it and/or modify  #
// #    it under the terms of the GNU General Public License as published by  #
// #    the Free Software Foundation; either version 2 of the License, or     #
// #    (at your option) any later version.                                   #
// #                                                                          #
// #    This program is distributed in the hope that it will be useful,       #
// #    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
// #    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
// #    GNU General Public License for more details.                          #
// #                                                                          #
// #    You should have received a copy of the GNU General Public License     #
// #    along with this program; if not, write to the                         #
// #    Free Software Foundation, Inc.,                                       #
// #    59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             #
// ############################################################################
#include "listviewsort.h"

ListViewSort::ListViewSort( QListView *parent ) :
  QListViewItem(parent)
{
  sortType = Text;
}

ListViewSort::ListViewSort( QListViewItem *parent ) :
  QListViewItem(parent)
{
  sortType = Text;
}

ListViewSort::ListViewSort( QListView *parent, QListViewItem *after ) :
  QListViewItem( parent, after )
{
  sortType = Text;
}

ListViewSort::ListViewSort( QListViewItem *parent, QListViewItem *after ) :
  QListViewItem( parent, after )
{
  sortType = Text;
}

ListViewSort::ListViewSort( QListView *parent, QString label1, QString label2, \
			    QString label3, QString label4, QString label5, \
			    QString label6, QString label7, QString label8 ) :
  QListViewItem( parent, label1, label2, label3, label4, label5, label6, label7, label8)
{
  sortType = Text;
}

ListViewSort::ListViewSort( QListViewItem *parent, QString label1, QString label2, \
			    QString label3, QString label4, QString label5, \
			    QString label6, QString label7, QString label8 ) :
  QListViewItem( parent, label1, label2, label3, label4, label5, label6, label7, label8)
{
  sortType = Text;
}

ListViewSort::ListViewSort( QListView *parent, QListViewItem *after, QString label1, \
			    QString label2, \
			    QString label3, QString label4, QString label5, \
			    QString label6, QString label7, QString label8 ) :
  QListViewItem( parent, after, label1, label2, label3, label4, label5, label6, label7, label8)
{
  sortType = Text;
}

ListViewSort::ListViewSort( QListViewItem *parent, QListViewItem *after, QString label1, \
			    QString label2, \
			    QString label3, QString label4, QString label5, \
			    QString label6, QString label7, QString label8 ) :
  QListViewItem( parent, after, label1, label2, label3, label4, label5, label6, label7, label8)
{
  sortType = Text;
}


void ListViewSort::setSortType( SortType type ) {
  sortType = type;
}


int ListViewSort::compare( QListViewItem *i, int col, bool ascending ) const {
  //-- try converstion to int
  bool ok;
  int a,b;
  a = text(col).toInt(&ok);
  if (ok){
    b = i->text(col).toInt(&ok);
    if (ok) return a-b;
  }

  //-- try format: "(<int>)"
  if (sscanf(text(col).ascii(), "(%d)", &a) && 
      sscanf(i->text(col).ascii(), "(%d)", &b)) 
    return a-b;

  //-- finally: string comparison
  return QListViewItem::compare(i, col, ascending);
}
