#!/usr/bin/perl -w
# Author: RedDwarf, based on script from merkosh
# Author:   $Author: merkosh $
# Revision: $Rev: 178 $
############################################################################
#    Copyright (C) 2005 by Uwe Mayer                                       #
#    merkosh@hadiko.de                                                     #
#                                                                          #
#    This program is free software; you can redistribute it and/or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 2 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             #
############################################################################

#---------------------------------------------------------#
# scan Culturalia for a number of fields on a movie title #
#---------------------------------------------------------#

#-- imports --------------------------------------------------------------------
use URI::Escape;
use LWP::UserAgent;
use HTTP::Request;
use HTML::Entities;
use File::Basename;
use POSIX qw(ceil);

use LMCTools;

#-- display help screen --------------------------------------------------------
if ((grep /--help|-h/,@ARGV) || (scalar @ARGV == 0)) {
  print STDERR <<HELP;
culturalia-es.pl  \$Rev\$  (c)  2005-01-04  by Christian Morales Vega

Search www.culturalianet.com for descriptive information on a movie title.

Synopsis: culturalia-es.pl [-h|--help] <title>|<URL>

     -h     --help     this screen
     <title>           search for <title> on imdb and return either the
                       the information or a list of matches
     <URL>             get information from this URL

The URL is distinguished from the title by the prefix \'http://\'. If
your title happens to have this prefix you\'re busted. ;)

If your internet connection needs a proxy server set the environment
variable "http_proxy" to the appropriate url 
(i.e. http_proxy=http://proxy.somehost.com:8080)

HELP
  exit();

}


#-- parse arguments ------------------------------------------------------------
my $title = "";
my $URL = "";

if (substr($ARGV[0], 0,7) eq 'http://') {
  $URL = $ARGV[0];
} else {
  $title = $ARGV[0];
}


#-- scan culturalia ------------------------------------------------------------------
$baseURL = 'http://www.culturalianet.com/bus/catalogo.php?catalogo=1&codigo=';
$searchURL = 'http://www.culturalianet.com/bus/catalogo.php?catalogo=1&texto=';
$donde = '&donde=1';


#-- title ----------------------------------------------------------------------
if ($title) {
  #-- get list of titles
  $page = getPage($searchURL.uri_escape($title).$donde)->content();

  %match = ();
  $totalResults = 0;
  $pos = 0;
  $pos = index($page, 'Codigo');
  #-- parse search (possible) section
  while ( $pos != -1 ) {
    $pos = index($page, 'Codigo');
    $page = substr($page, $pos+1);
    $page =~ /\= (.+?)\<br\>Titulo \= (.+?)\.\<br\>Titulo original \= (.+?)\<br\>Ao \= (.+?)<br>/;
    push @{$match}, {URL => $1, Text => decode_entities("$2 ($3), $4")};
    $totalResults++;
    $pos = index($page, 'Codigo');
  }


  #-- output Results
  if ($totalResults == 0){
    print "status: failed\n";
  } else {
    print "status: list\n";

      foreach $rec (@{$match}){
	print "title: $rec->{Text}\n";
	print "url: $baseURL$rec->{URL}\n";
	print "\n";
      }    
  }
  exit();
}


#-- URL ------------------------------------------------------------------------
if ($URL){
  #-- get main page
  $response = getPage($URL);
  $page = $response->content();
  # fields we are looking out for:
  %data = ();
  # - originalTitle
  # - year
  # - picture
  # - director
  # - category
  # - actors
  # - url  
  # - country
  # - description
  # - producer
  # - translated title

  # the following are not available
  # - comments
  # - length
  # - rating
  # - language

  # original title
  $tmp = &find($page, 'Titulo original = ');
  $data{'originalTitle'} = decode_entities($1) if ($tmp =~ / \= (.+?)\<br\>/);

  # year
  $tmp = &find($tmp, 'Ao = ');
  $data{year} = $1 if ($tmp =~ / \= (\d+)\<br\>/);

  # picture
  $tmp = &find($page, 'Imagen = ');
  $data{'picture'} = decode_entities($1) if ($tmp =~ / \= (.+?)\<br\>/);

  # director
  $tmp = &find($page, 'Director = ');
  @director = ();
  $tmp =~ / \= (.+?)\<br\>/;
  @director= split /,\s*/, $1;
  $data{director} = \@director if (scalar @director);
  
  # category
  $tmp = &find($page, 'Genero = ');
  @category = ();
  $tmp =~ / \= (.+?)\<br\>/;
  @category = split /,\s*/, $1;
  $data{category} = \@category if (scalar @category);
  
  # actors
  $tmp = &find($page, 'Actores = ');
  @actors = ();
  $tmp =~ / \= (.+?)\<br\>/;
  @actors = split /,\s*/, $1;
  $data{actors} = \@actors if (scalar @actors);

  # url
  $tmp = &find($page, 'URL = '); 
  $data{url} = decode_entities($1) if ($tmp =~ / \= (.+?)\<br\>/);

  # country
  $tmp = &find($page, 'Nacion = ');
  @country = ();
  $tmp =~ / \= (.+?)\<br\>/;
  @country = split /,\s*/, $1;
  $data{country} = \@country if (scalar @country);

  # description
  $tmp = &find($page, 'Sinopsis = ');
  $data{description} = decode_entities($1) if ($tmp =~ / \= (.+?)\<br\>/);

  # comments
  @comments = ();
  @sections = ("Guion = ", "Fotografia = ", "Musica = ");

  foreach $sec (@sections){
    $tmp = &find($page, $sec);
    $tmp =~ /(.+?)\<br\>/;
    push @comments, decode_entities($1);
  }
  $data{comments} = join("<br>", @comments) if (scalar @comments);

  # translated title
  $tmp = &find($page, 'Titulo = ');
  $data{'translatedTitle'} = decode_entities($1) if ($tmp =~ / \= (.+?)\.\<br\>/);
  
  # producer  
  $tmp = &find($page, 'Productor = ');
  @producer = ();
  $tmp =~ / \= (.+?)\<br\>/;
  @producer = split /,\s*/, $1;
  $data{producer} = \@producer if (scalar @producer);

  #-- output
  # nothing found
  exit if ((scalar keys(%data) == 1) && (exists $data{url}));

  # return normal status
  print "status: details\n";

  foreach $k (keys(%data)){
    if ($k =~ /actors|category|producer|director|country/){
      foreach (@{$data{$k}}){
	print "$k: $_\n";
      }
    }
    else {
      print "$k: $data{$k}\n";
    }
    print "\n";
  }


}
