# -*- coding: utf-8 -*-
# Author:   $Author: merkosh $
# Revision: $Rev: 48 $
############################################################################
#    Copyright (C) 2005 by Uwe Mayer                                       #
#    merkosh@hadiko.de                                                     #
#                                                                          #
#    This program is free software; you can redistribute it and/or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 2 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             #
############################################################################

#-- imports --------------------------------------------------------------------
#-- Qt imports
from qt import QIODevice


#-- Python imports
import logging
from StringIO import StringIO


#-- preferences ----------------------------------------------------------------
pref = {
    'logLevel': logging.DEBUG,
    }

# This can be used to save raw data from QImage from
# The only methods required are: flush() and writeBlock()

class IODeviceBuffer(QIODevice):
    """uses StringIO as intermediate buffer for taking up raw data

    This can be used as replacement for QBuffer and QByteArray
    to read data from Qt objects which normally write to QIODevice
    instances.
    """
    def __init__(self):
        """create buffer"""
        QIODevice.__init__(self)
        # create logging
        self.log = logging.getLogger( self.__class__.__name__ )
        self.log.setLevel(pref['logLevel'])
        # initialise buffer
        self.buffer = StringIO()

    def open(self, mode):
        """NOT IMPLEMENTED: opens a file in a specific mode; returns success status"""
        raise NotImplementedError()

    def close(self):
        """closes StringIO and frees memory"""
        self.buffer.close()

    def flush(self):
        """NOT IMPLEMENTED: flushes IO device"""
        self.log.debug("flush: noop")
        
    def size(self):
        """returns size of IO device"""
        return len(self.buffer.getvalue())

    def at(self, position=None):
        """NOT IMPLEMENTED: returns current IO device position or tests current position"""
        raise NotImplementedError()

    def atEnd(self):
        """NOT IMPLEMENTED: returns wether IO device is at end of input"""
        raise NotImplementedError()

    def readBlock(self, data, maxlen):
        """NOT IMPLEMENTED: reads at most maxlen bytes from IO device into data; returns bytes read"""
        raise NotImplementedError()

    def writeBlock(self, data, len=None):
        """writes len bytes from data to StringIO; returns bytes written"""
        length = self.buffer.tell()
        self.buffer.write(data)
        return self.buffer.tell() -length

    def readLine(self, data, maxlen):
        """NOT IMPLEMENTED: reads a line of text up to maxlen bytes, including tailing '\0'

        Return: returns number of bytes
        """
        raise NotImplementedError()

    def readAll(self):
        """returns all data from StringIO"""
        return self.buffer.getvalue()

    def getch(self):
        """NOT IMPLEMENTED: reads a single byte from IO device; returns byte read"""
        raise NotImplementedError()

    def putch(self, char):
        """NOT IMPLEMENTED: writes character to IO device; returns character or -1 on error"""
        raise NotImplementedError()

    def ungetch(self, char):
        """NOT IMPLEMENTED: puts character back onto IO device and decrements index position

        Return: character or -1 on error
        """
        raise NotImplementedError()


#-- testarea -------------------------------------------------------------------
if (__name__ == '__main__'):
    from qt import QImage

    log = logging.getLogger("")
    hdlr = logging.StreamHandler()
    formatter = logging.Formatter('[%(name)s] %(levelname)s: %(message)s')
    hdlr.setFormatter(formatter)
    log.addHandler(hdlr) 
    log.setLevel(pref['logLevel'])


    img = QImage("pictures/movie_0001.jpg")
    buf = IODeviceBuffer()

    img.save(buf, "JPEG")
