# -*- coding: utf-8 -*-
# Author:   $Author: merkosh $
# Revision: $Rev: 124 $
############################################################################
#    Copyright (C) 2005 by Uwe Mayer                                       #
#    merkosh@hadiko.de                                                     #
#                                                                          #
#    This program is free software; you can redistribute it and/or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 2 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             #
############################################################################

#-- imports --------------------------------------------------------------------
#-- Qt imports
from qt import SIGNAL, QListView, QListViewItem

#-- Python imports
import logging
import sys

from os.path import getsize as fsize


#-- own imports
from CataloguePropertiesBase import CataloguePropertiesBase
from Settings import getPreferences
from MediaInfo import MediaInfo


#-- preferences ----------------------------------------------------------------
pref = getPreferences(__name__)



class CatalogueProperties(CataloguePropertiesBase):
    """allows modification of file header information"""
    def __init__(self, file, parent=None, name=None, modal=False, fl=0):
        CataloguePropertiesBase.__init__(self, parent, name, modal, fl)

        self.log = logging.getLogger( self.__class__.__name__)
        self.log.setLevel(pref['logLevel'])

        # runtime variables
        self.modified = False
        self.file = file

        # initialise field values
        name = self.file.name
        if (len(name) > 50):
            name = "...%s"%name[-50:]
        self.textLabelFileName.setText(name)

        filesize = fsize(self.file.name)
        self.textLabelSize.setText("%s Bytes (%s)"%(str(filesize), MediaInfo.normalizeFileSize(filesize)))

        self.textLabelFormat.setText(unicode(type(self.file)))

        self.lineEditUserName.setText(self.file['name'])
        self.lineEditMail.setText(self.file['mail'])
        self.lineEditIcq.setText(self.file['icq'])
        self.lineEditWebsite.setText(self.file['site'])
        self.textEditDescription.setText(self.file['description'])

        # connect signals
        self.connect(self.lineEditUserName, SIGNAL("textChanged(const QString&)"), self.onModified)
        self.connect(self.lineEditMail, SIGNAL("textChanged(const QString&)"), self.onModified)
        self.connect(self.lineEditIcq, SIGNAL("textChanged(const QString&)"), self.onModified)
        self.connect(self.lineEditWebsite, SIGNAL("textChanged(const QString&)"), self.onModified)
        self.connect(self.textEditDescription, SIGNAL("textChanged()"), self.onModified)


    def onModified(self):
        """called when changes were made to the file properties"""
        self.modified = True


    def accept(self):
        """called when ok button is pressed"""
        if (self.modified):
            self.file['name'] = unicode(self.lineEditUserName.text())
            self.file['mail'] = unicode(self.lineEditMail.text())
            self.file['icq'] = unicode(self.lineEditIcq.text())
            self.file['site'] = unicode(self.lineEditWebsite.text())
            self.file['description'] = unicode(self.textEditDescription.text())
            
        CataloguePropertiesBase.accept(self)
        

    def modified(self):
        """returns wether the file metadata was modified"""
        return self.modified()
        
        

#-- testroutine ----------------------------------------------------------------
if (__name__ == '__main__'):
    from qt import QApplication, QObject, SLOT
    
    a = QApplication(sys.argv)
    QObject.connect(a,SIGNAL("lastWindowClosed()"),a,SLOT("quit()"))

    

    w = CatalogueProperties()
    w.exec_loop()


#-- EOF --
