#include <stdlib.h>

#include <check.h>

#include "pipeline.h"

#define TEST_CASE(suite, test, name) \
	do { \
		TCase *t = tcase_create (#name); \
		tcase_add_test (t, test_##test##_##name); \
		suite_add_tcase (suite, t); \
	} while (0)

#define MAIN(test) \
	int main (int argc PIPELINE_ATTR_UNUSED, \
		  char **argv PIPELINE_ATTR_UNUSED) \
	{ \
		int failed; \
		Suite *s = test##_suite (); \
		SRunner *sr = srunner_create (s); \
\
		srunner_run_all (sr, CK_ENV); \
		failed = srunner_ntests_failed (sr); \
		srunner_free (sr); \
		return (failed == 0) ? EXIT_SUCCESS : EXIT_FAILURE; \
	}

