#include "leg/support/window/window.h"
#include "leg/support/utils/errors.h"
#include <iostream>
#include <cstdlib>

using namespace leg::support::window;
using namespace std;

template<class TW>
class MyWindow: public TW
{
   public:

   MyWindow (DisplayConnect& disp): TW (disp){}

   ~MyWindow(){}

   void Draw()
   {
      static bool first=true;
      if(first){
	 first=!first;
	 std::cout << "Drawing." << std::endl;
      }
      static float a=0;
      static float b=0;
      if ((a+=.1)>360)
	 a-=360;
      if ((b+=.125)>360)
	 b-=360;
      glPushMatrix();
	 glScalef (.5,.5,.5);
	 glRotatef (a,1,0,0);
         glRotatef (b,0,1,0);
         glBegin (GL_LINES);
	    glColor3f (1,0,0);
            glVertex3f (0,0,0);
            glVertex3f (1,0,0);
	    glColor3f (0,1,0);
	    glVertex3f (0,0,0);
	    glVertex3f (0,1,0);
	    glColor3f (0,0,1);
	    glVertex3f (0,0,0);
	    glVertex3f (0,0,1);
	 glEnd();
      glPopMatrix();
   }
};

int main (int argc, char **argv)
{
   typedef AbstractWindow<OSWindow> GLXType;
   
   GLXType *win=0;
   
   cout << "creating display..." << flush;
   leg::support::window::DisplayConnect *dc = new leg::support::window::DisplayConnection();
   //DisplayConnect *dc= new GLXDisplay;
   cout << " done." << endl << "opening display..." << flush;
   dc->Open();
   int glx_maj=0,glx_min=0;
   dc->GetGLWMVersion (glx_maj,glx_min);
   cout << " done." << endl << "constructing window..." << flush;

   win= new MyWindow<GLXType> (*dc);
   
   cout << " done." << endl;

   if (argc>1)
      if (!strcmp (argv[1], "-f"))
         win->GetAttributes().SetFullScreenUse (true);
   win->GetAttributes().SetKeyboardAutoRepeatMode (dc->Get(), false);
   //win->GetAttributes().SetDecorationUse (false);
   
   cout << "creating window..." << endl;
   win->Create();

   cout << " done." << endl;

   leg::support::window::Event events (dc->Get(),win->GetAttributes());
   leg::support::window::UserEvent *ev = 0;
  
   cout << "Running. (Press and release a key to stop the test)." << endl;
   
   while(1>0){
      events.Update();
      if (!(ev = events.GetLastEvent()))
	 ;
      else if (ev->type == leg::support::window::UserEvent::key_release)
	 break;
      //win->Draw();
   }

   delete win;
   win = 0;
   delete dc;
   dc = 0;
   
   return 0;
}

