
// Tests the second layer of threads in a concurrent style.

#include <leg/libs/threads/threads.h>
#include <iostream>

using namespace leg;

/*
 * This is the Cell class of a ThreaderCell.
 * Any cell have to inherit from a template class representing a thread
 * synchronization tool (as a mutex).
 */
template <class TSync>
struct MyThread: public TSync
{
   typedef TSync Parent;
   
   using Parent::Lock;
   using Parent::Unlock;
   using Parent::Wait;
   using Parent::Signal;
   
   static volatile int i;  // we share this memory portion between threads.
			   // This tells we use some concurrent threading.
			   
   bool incr;  // if true, then will increment, otherwise will decrement.
   
   // It's important that the constructor has no arguments and explicitly
   // calls to the default constructor of its parent if concurrent
   // threading is used (our case).
   MyThread () :  Parent()
   {
   }
   
   // runs the thread.
   void*
   Go (void *args = 0)
   {
      if (incr){
	 Lock ();
	 i = i + 1;
	 std::cout << "Incr: " << i << std::endl;
	 Unlock();
      }
      else{
	 Lock ();
	 i = i - 1;
	 std::cout << "Decr: " << i << std::endl;
	 Unlock();
      }
      return 0;
   }
};

// We use this type as our default type.
typedef libs::threads::ThreaderCell<MyThread> LegThread;

//typedef MyThread<libs::threads::Sync<support::threads::Mutex> > ThisThread;

// assignment
//volatile int ThisThread::i = 0;

int main (int argc, char **argv)
{
   // we declare 2 threads that will be in the state 'constructed'.
   LegThread my_thread;
   
   // the 2nd one is a copy from the 1st.
   LegThread my_thread_2 (my_thread);
   
   // we set the impl choose of the threads.
   my_thread.incr= true;
   my_thread_2.incr= false;

   // we load the threads that creates, load, then runs them. But they reach 
   // a state that is waiting.
   my_thread.Load();
   my_thread_2.Load();

   // starting synchronizer.
   std::string s;
   std::cout << "Enter a string to start the threads.";
   std::cin >> s;
   
   // we throw signal to the waiting threads, telling them that they are ready.
   // This will provoke the thread to reach the 'running' state, so looping.
   my_thread.SignalReady();
   my_thread_2.SignalReady();
   
   // the main thread has nothing to do, but could not be leaved...
   while(1);
   
   return 0;
}
