#include <leg/support/system/system.h>
#include <leg/libs/window/window.h>
#include <iostream>

using namespace leg;

int main (int argc, char **argv)
{
   typedef leg::libs::window::Window<> MyWindow;

   leg::support::window::DisplayConnect *dc = new leg::support::window::DisplayConnection();
   dc->Open();
   
   leg::support::window::Window *win = new MyWindow (*dc);
   win->Create();
  
   support::system::GraphicCard gc;
   std::cout << gc.GetNameFromGl() << std::endl;
   std::cout << gc.GetExtensionsFromGl() << std::endl;
   std::cout << gc.GetExtensionsFromGlu() << std::endl;
   std::cout << gc.GetVendorFromGl() << std::endl;
   std::cout << gc.GetVersionFromGl() << std::endl;

   delete win;
   win = 0;
   dc->Close();
   delete dc;
   dc = 0;

   return 0;
}
