#include "leg/libs/scene/scene.h"
#include <iostream>

using namespace leg::libs::scene;
using namespace std;

int main (int argc, char **argv)
{
   typedef World<Organisation<std::list<Entity*> > > AWorld;
   
   cout << "world = new AWorld" << endl;
   WorldInterface *world = new AWorld;

   Camera *cam = new SimpleCamera;
   Object *obj = new SimpleObject;
   Object *sta = new StaticObject;
   Light *p_light= new PointLight;
   Light *i_light = new InfiniteLight;

   Vector cp (10,20,30);
   Vector cs (5,5,25);
   Vector co (3.14,.0,.0);

   cam->SetPosition (cp);
   cam->SetOrientation (co);
   cam->SetSize (cs);
   
   world->AddObject (*cam);
   world->AddObject (*obj);
   world->AddObject (*sta);
   world->AddObject (*p_light);
   world->AddObject (*i_light);
   
   IO io;

   cout << "Saving scene world into scene.lsc..." << endl;
   io.Save ("scene.lsc", *world);
   cout << "   done." << endl;
   cout << "Saved world has " << world->CountObjects() << " elements." << endl;

   cout << "Loading scene.lsc..." << endl;
   WorldInterface *world2 = io.Load<Organisation<std::list<Entity*> > > ("scene.lsc");
   cout << "   done." << endl;
   cout << "Loaded world has " << world2->CountObjects() << " elements." << endl;
   
   return 0;
}
