#include "leg/libs/window/window.h"
#include "leg/libs/graphics/graphics.h"
#include "leg/libs/threads/sync.h"
#include "leg/libs/physics/physics.h"
#include <iostream>

using namespace std;
using namespace leg;

struct MyDrawer
{
   libs::physics::Entity *entity;
   libs::physics::Entity *gentity;
   libs::physics::Gravitron *gravitron;
   libs::physics::Timing timing;
   libs::physics::GameTime gt;
   libs::physics::Entity *bounding;
   
   MyDrawer(): entity (new libs::physics::SimpleEntity)
   {
      libs::physics::Vector p (-1,0,0);
      entity->SetPosition (p);
      libs::physics::Vector v (1,0,0);
      entity->SetVelocity (v);
      entity->SetSpeed (1);
      entity->SetMass (.5);
      /*libs::physics::Vector a (1,1,1);
      entity->SetAcceleration (a);
      entity->SetAccelerationMagnitude (.1);*/

      gravitron = new libs::physics::Gravitron;
      libs::physics::Vector g (0,-10,0);
      gravitron->SetGravity (g);

      libs::physics::Vector p2 (0,3,-4);
      libs::physics::Vector v2 (0,0,1);
      gentity = new libs::physics::SimpleEntity;
      gentity->SetMovingConfig (libs::physics::move_follows_velocity);
      gentity->SetPosition (p2);
      gentity->SetVelocity (v2);
      gentity->SetSpeed (.2);
      gentity->SetMass (5);

      libs::physics::Vector p3 (0,2,1.5);
      libs::physics::Vector v3 (0,1,0);
      bounding = new libs::physics::BoundingEntity;
      bounding->SetMovingConfig (libs::physics::move_follows_velocity);
      bounding->SetPosition (p3);
      bounding->SetVelocity (v3);
      bounding->SetMass (.5);

      gravitron->Submit (*gentity);
      gravitron->Submit (*bounding);
   }
   
   ~MyDrawer()
   {
      delete entity;
      entity = 0;
      delete gentity;
      gentity = 0;
      delete gravitron;
      gravitron = 0;
      delete bounding;
      bounding = 0;
   }
   
   void 
   Draw()
   {
      static bool first=true;
      static libs::physics::Orientation ori (0,0,0);
      gt = timing.GetCurrentTime();
      static libs::physics::GameTime old_gt = gt;
      
      if(first){
	 first=!first;
	 std::cout << "Drawing." << std::endl;
      }

      ori (0)+= (gt-old_gt);
      if (ori(0) > support::maths::two_pi)
	 ori(0) -= support::maths::two_pi;
      ori (1)= support::maths::two_pi * (old_gt-gt);
      old_gt = gt;
      
      gravitron->Update();
      
      entity->SetOrientation (ori);
      entity->Update();

      gentity->Update();

      bounding->Update();

      support::maths::real px = entity->GetPosition()(0);
      support::maths::real py = entity->GetPosition()(1);
      support::maths::real pz = entity->GetPosition()(2);

      support::maths::real p2x = gentity->GetPosition()(0);
      support::maths::real p2y = gentity->GetPosition()(1);
      support::maths::real p2z = gentity->GetPosition()(2);

      support::maths::real p3x = bounding->GetPosition()(0);
      support::maths::real p3y = bounding->GetPosition()(1);
      support::maths::real p3z = bounding->GetPosition()(2);

      glClear (GL_COLOR_BUFFER_BIT);
      glMatrixMode (GL_MODELVIEW);
      glLoadIdentity();
      glPushMatrix();
      
      gluLookAt (2,3.3,2,0,0,0,0,1,0);
      
      glPushMatrix();
         glBegin (GL_LINES);	 
	    int i = -3;
	    glColor3f (.5,.5,.5);
	    for (;i<4;++i){
	       glVertex3f (-3,0,i);
	       glVertex3f (3,0,i);
	    }
	    for (i=-3;i<4;++i){
	       glVertex3f (i,0,-3);
	       glVertex3f (i,0,3);
	    }
	 glEnd();
	 glBegin (GL_QUADS);
	    for (i=3;i>=0;--i){
	       glVertex3f (-.5,i,-i);
	       glVertex3f (-.5,i,-i-1);
	       glVertex3f (.5,i,-i-1);
	       glVertex3f (.5,i,-i);
	    }
	    for (i=0;i>-5;--i){
	       glVertex3f (-.5,i,-i+1);
	       glVertex3f (-.5,i,-i);
	       glVertex3f (.5,i,-i);
	       glVertex3f (.5,i,-i+1);
	    }
	 glEnd();
	 glBegin (GL_LINES);
	    glColor3f (1,0,0);
            glVertex3f (0,0,0);
            glVertex3f (1,0,0);
	    
	    glColor3f (0,1,0);
	    glVertex3f (0,0,0);
	    glVertex3f (0,1,0);
	    
	    glColor3f (0,0,1);
	    glVertex3f (0,0,0);
	    glVertex3f (0,0,1);

	    glColor3f (1,1,1);
	    glVertex3f (0,0,0);
	    glVertex3f (px,py,pz);

	    glColor3f (1,0,1);
	    glVertex3f (0,0,0);
	    glVertex3f (p2x,p2y,p2z);

	    glColor3f (1,1,0);
	    glVertex3f (0,-1,1.5);
	    glVertex3f (p3x,p3y,p3z);
	 glEnd();
      glPopMatrix();

      glPopMatrix();
   }
};

struct MyHudDrawer
{
   MyHudDrawer(){}
   ~MyHudDrawer(){}
   
   void
   HudDraw()
   {
      ;
   }
};

int main (int argc, char **argv)
{
   typedef leg::libs::window::Window<> MyWindow;
   typedef leg::libs::graphics::Drawer<MyDrawer,MyHudDrawer,MyWindow> MyDrawer;

   leg::support::window::DisplayConnect *dc = new leg::support::window::DisplayConnection();
   dc->Open();
   
   leg::support::window::Window *win = new MyWindow (*dc);

   if (argc>1)
      if (!strcmp (argv[1], "-f"))
         win->GetAttributes().SetFullScreenUse (true);
   
   win->Create();
   MyDrawer drawer (static_cast<MyWindow&> (*win));
   leg::support::window::Event events (dc->Get(),win->GetAttributes());
   
   cout << "Running. (Press and release a key to stop the test)." << endl;
   
   while(1>0){
     events.Update();
/*      if (!(ev = events.GetLastEvent()))
	 ;//continue;
      else if (ev->type == leg::support::window::UserEvent::key_release)
	 break;
*/      drawer.Draw();
   }

   delete win;
   win = 0;
   dc->Close();
   delete dc;
   dc = 0;

   return 0;
}

