#include "leg/libs/window/window.h"
#include "leg/libs/interactivity/interactivity.h"
#include "leg/libs/graphics/graphics.h"
#include <iostream>

using namespace std;

struct MyDrawer
{
   leg::support::maths::Vector<3> eye, target, up;
   
   MyDrawer()
   {
      eye(0) = 0;
      eye(1) = 0;
      eye(2) = 1;

      target(0) = 0;
      target(1) = 0;
      target(2) = 0;

      up(0) = 0;
      up(1) = 1;
      up(2) = 0;
   }
   
   ~MyDrawer()
   {
   }
   
   void 
   Draw()
   {
      static bool first=true;
      if(first){
	 first=!first;
	 std::cout << "Drawing." << std::endl;
      }
      
      gluLookAt ( eye(0), eye(1), eye(2), target(0), target(1), target(2), up(0), up(1), up(2));
      
      glPushMatrix();
	 glScalef (.5,.5,.5);
	 /*glRotatef (a,1,0,0);
         glRotatef (b,0,1,0);*/
         glBegin (GL_LINES);
	    glColor3f (1,0,0);
            glVertex3f (0,0,0);
            glVertex3f (1,0,0);
	    glColor3f (0,1,0);
	    glVertex3f (0,0,0);
	    glVertex3f (0,1,0);
	    glColor3f (0,0,1);
	    glVertex3f (0,0,0);
	    glVertex3f (0,0,1);
	 glEnd();
      glPopMatrix();
   }
};

struct MyHudDrawer
{
   MyHudDrawer(){}
   ~MyHudDrawer(){}
   
   void
   HudDraw()
   {
      ;
   }
};

int main (int argc, char **argv)
{
   typedef leg::libs::window::Window<> MyWindow;
   typedef leg::libs::graphics::Drawer<MyDrawer,MyHudDrawer,MyWindow> MyDrawer;
   
   leg::support::window::DisplayConnect *dc = new leg::support::window::DisplayConnection();
   dc->Open();
   
   leg::support::window::Window *win = new MyWindow (*dc);

   if (argc>1)
      if (!strcmp (argv[1], "-f"))
         win->GetAttributes().SetFullScreenUse (true);
   
   win->Create();

   MyDrawer drawer (static_cast<MyWindow&> (*win));

    //
   // Init of interactivity
    //
   
   leg::libs::interactivity::Event events (*win);

   leg::libs::interactivity::Keyboard::SetSaveString (true);
   
   cout << "Running. (Just press and release [Escape] key to stop the test)." << endl;
   
   int i = 0;
   leg::libs::interactivity::real mx = 0, my = 0;
   leg::support::timing::Timing timing;
   leg::libs::interactivity::GameTime gt = timing.GetCurrentTime();
   leg::libs::interactivity::GameTime tt = gt;
   
   while(1>0){
      events.Update();
      drawer.Draw();
      
      for (i=1;i<=5;++i){
	 if (leg::libs::interactivity::Mouse::IsButtonClicked (i))
	    cout << "button " << i << " is clicked." << endl;
	 if (leg::libs::interactivity::Mouse::IsButtonDoubleClicked (i))
	    cout << "button " << i << " is double clicked." << endl;
      }
      
      mx = leg::libs::interactivity::Mouse::GetCoord().x;
      my = leg::libs::interactivity::Mouse::GetCoord().y;
      
      std::cout << "Win coord: x = " << mx << " ; y = " << my << endl;
      leg::libs::interactivity::Mouse::GetCoord().RangeToSize();
      mx = leg::libs::interactivity::Mouse::GetCoord().x;
      my = leg::libs::interactivity::Mouse::GetCoord().y;
      std::cout << "Range coord: rx = " << mx << " ; ry = " << my << endl;

      if (leg::libs::interactivity::Keyboard::IsKeyReleased (leg::support::window::key::key_escape))
	 break;

/*      if ((tt = timing.GetCurrentTime()) > (gt + 1)){
	 // we should give an argument to the function telling if we empty the string or not:
	 // because it is empties each time we call it. And it could be interresting to not
	 // empty it before we get some wanted string for example.
	 cout << "Current string: " << leg::libs::interactivity::Keyboard::GetCurrentString() << endl;
	 gt = tt;
      }
*/   }
   
   delete win;
   win = 0;
   dc->Close();
   delete dc;
   dc = 0;
   
   return 0;
}

