#include <iostream>
#include <leg/support/guile/guile.h>

using namespace std;
using namespace leg::support::guile;
using namespace Loki;

class a
{
public:
  a (int i) : i (ToGuile (i)) {}

  ~a () { cout << "a deallocated.\n"; }

  void p () { std::cout << i.GetValue<int> () << std::endl; }

  int GetI () { return i.GetValue<int> (); }
  int Other_getI () { return i.GetValue<int> (); }
  void SetI (int ii) { i = ToGuile<int> (ii); }

  void
  Print (Scheme port, scm_print_state *s)
  {
    scm_display (ToGuile ("#<test "), port.GetSCM ());
    scm_display (ToGuile (i), port.GetSCM ());
    scm_display (ToGuile (">"), port.GetSCM ());
  }

  bool
  operator == (a &other)
  {
    return other.i.GetValue<int> () == i.GetValue<int> ();
  }

private:

  Scheme i;
};

void
function (int i)
{
  cout << "function has been called with argument " << i << endl;
}

void
test_smob ()
{
  SmartPtr<a> b = CallFunction1<SmartPtr<a> > ("new-test", 2);
  
  FromGuile<SmartPtr<a> > (ToGuile (b))->p ();
  
  CallVoidFunction1 ("display", b);
  cout << endl;
  
  CallVoidFunction1 ("(lambda (a) (display (get-test-i a)))", b);
  cout << endl;
  
  CallVoidFunction1 ("(lambda (a) (set-test-i a 1))", b);
  b->p ();
}

int
main (int argc, char *argv[])
{
  AddType<a> ("test");
  SetTypePrintFcn<a, &a::Print> ();
  SetTypeComparable<a> ();

  AddConstructorBinding1<a, int> ("new-test");

  AddMemberBinding0<a, int, &a::GetI> ("get-test-i");
  AddMemberBinding0<a, int, &a::Other_getI> ("other-get-test-i");
  AddVoidMemberBinding1<a, int, &a::SetI> ("set-test-i");

  AddVoidBinding1<int, function> ("function");

  SmartPtr<a> b = CallFunction1<SmartPtr<a> > ("new-test", 2);
  
  FromGuile<SmartPtr<a> > (ToGuile (b))->p ();
  
  CallVoidFunction1 ("display", b);
  cout << endl;
  
  CallVoidFunction1 ("(lambda (a) (display (get-test-i a)))", b);
  cout << endl;
  
  CallVoidFunction1 ("(lambda (a) (set-test-i a 1))", b);
  b->p ();

  CallVoidFunction1 ("function", 3);

  EvalExpression<void> ("(display 4) (newline)");
  cout << EvalExpression<double> ("(+ 4 (* 2 1/2))") << endl;
  cout << EvalExpression<string> ("(string #\\a #\\b)") << endl;


  vector<int> v = EvalExpression<vector<int> > ("(vector 1 2 3 4)");
  for (vector<int>::iterator i = v.begin (); i != v.end (); ++i)
    {
      cout << *i << "; ";
    }
  cout << endl;
  v.push_back (5);
  CallVoidFunction1 ("(lambda (a) (display a) (newline))", v);


  list<int> l = EvalExpression<list<int> > ("(list 1 2 3 4)");
  for (list<int>::iterator i = l.begin (); i != l.end (); ++i)
    {
      cout << *i << "; ";
    }
  cout << endl;
  l.push_front (0);
  CallVoidFunction1 ("(lambda (a) (display a) (newline))", l);
}
