(create-window!
 (let ((first #t)
       (light-1 #f)
       (light-2 #f)
       (light-3 #f)
       (light-4 #f)
       (a 0))
   (lambda ()
     (if first
	 (begin
	   (set! first #f)
	   (set-global-option! GL_LIGHTING #t)
	   
	   (set! light-1 (new-infinite-light 1 1 1))
	   (set-light-diffuse-color! light-1 1 0 0)
	   (light-enable! light-1)
	   
	   (set! light-2 (new-infinite-light 1 1 1))
	   (set-light-diffuse-color! light-2 0 1 0)
	   (light-enable! light-2)
	   
	   (set! light-3 (new-infinite-light 1 1 1))
	   (set-light-diffuse-color! light-3 0 0 1)
	   (light-enable! light-3)))
     
     (let ((q (new-quadric)))

       (set! a (+ a 0.01))

       (set-location! light-1 (cos a) (sin (* a 4)) (sin a))
       (set-location! light-2 (* -2 (sin (* a 2))) (sin a) (- (cos (* a 2))))
       (set-location! light-3 (* 3 (cos (* a 2/3))) (- (sin (* a 3/5))) (- (sin (* a 2/3))))

       (light-draw! light-1)
       (light-draw! light-2)
       (light-draw! light-3)
       (draw-sphere! q 1 200 200)))))
