#include "leg/support/window/sdl/sdlwindow.h"
#include <iostream>

using namespace std;

namespace leg
{
namespace support
{
namespace window
{
   
SDLWindow::SDLWindow (DisplayConnect& disp): Window (disp)
{
   drawable = new DrawableType;
   drawable->SetDisplay (disp.Get());
   width = 800;
   height = 600;
}

SDLWindow::~SDLWindow()
{
   delete drawable;
   drawable = 0;
}

void 
SDLWindow::Create()
{
   SDL_GL_SetAttribute (SDL_GL_DOUBLEBUFFER,1);
   SDL_GL_SetAttribute (SDL_GL_STENCIL_SIZE,8);
   SDL_GL_SetAttribute (SDL_GL_ALPHA_SIZE,4);
   
   int flags;

   flags = SDL_OPENGL;
   if (!attr.GetFullScreenUse())
      flags = flags | SDL_RESIZABLE;
   else{
      std::cout << "SDL fullscreen mode on." << std::endl;
      flags = flags | SDL_FULLSCREEN;
   }
   
   window = SDL_SetVideoMode (width,height,24,flags);

   if (!window){
      cout << "Error: cannot create SDL window: " << SDL_GetError();
      SDL_Quit();
      throw std::exception();
   }

   SDL_WM_SetCaption ("GNU Leg renderable","GNU Leg renderable");

   //Resize();
   is_created = true;
}

void 
SDLWindow::Destroy()
{
}

Attributes&
SDLWindow::GetAttributes()
{
   return attr;
}

void
SDLWindow::ShowCursor (bool)
{
}

void 
SDLWindow::SwitchToFullScreen()
{
   std::cout << "Swtiching to fullscreen." << std::endl;
   SDL_WM_ToggleFullScreen(window);
   attr.SetFullScreenUse (true);
}

void 
SDLWindow::SwitchToWindow()
{
   std::cout << "Switching to window." << std::endl;
   SDL_WM_ToggleFullScreen(window);
   attr.SetFullScreenUse (false);
}

}
}
}
