/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: xevent.cc,v 1.6 2004/06/19 11:15:44 jd Exp $

   Created 04/15/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/window/sdl/sdlevent.cc
 * \brief glx event handlings.
*/

#include "leg/support/window/sdl/sdlevent.h"
#include "leg/support/window/sdl/sdlkeymap.h"
#include "leg/support/utils/errors.h"
#include <iostream>

using leg::support::utils::Warning;
using namespace std;

namespace leg
{
namespace support
{
namespace window
{
   SDLEvent::SDLEvent (internal::Display *const d, Attributes& a):BaseEvent(),
								  disp (d)
   {
      a.GetSize (win_width,win_height);
   }

   SDLEvent::~SDLEvent()
   {
   }

   void
   SDLEvent::Update()
   {
      UserEvent ue;
      SDL_Event event;

      while (SDL_PollEvent (&event)){
	 switch (event.type){
	    case SDL_VIDEORESIZE:
	       /*
	       window.w = event.resize.w;
	       window.h = event.resize.h;
	       window.win = SDL_SetVideoMode (window.w, window.h, 24, SDL_OPENGL|SDL_RESIZABLE);
	       if (window.win)
		  Resize();
	       else{
		  cout << "Error in SDL" << endl;
		  exiting = 1;
		  throw std::exceptio();
	       }*/
	       break;

	    case SDL_KEYDOWN:
	       ue.type = UserEvent::key_press;
	       ue.event.key = event.key.keysym.sym;
	       event_queue.push (ue);
	       
	       current_key = ue.event.key;

	       // unicode is not enabled !!
	       /*
	       if (save_string_key)
		  if (!(event.key.keysym.unicode & 0xff80))
		     current_string_key += (event.key.keysym.unicode & 0x7f);
	       */
	       break;

	    case SDL_KEYUP:
	       ue.type = UserEvent::key_release;
	       ue.event.key = event.key.keysym.sym;
	       event_queue.push (ue);
	       MakeKeyRelease (ue.event.key);
	       break;

	    case SDL_MOUSEMOTION:
	       ue.type = UserEvent::mouse_motion;
	       ue.event.mouse.coord.x = event.motion.x;
	       ue.event.mouse.coord.y = event.motion.y;
	       /*
	       if (mouse_area_config == partial){
		  if (ue.event.mouse.coord.x < mouse_area.start_x)
		     XWarpPointer (disp, None, None, 0,0,0,0,mouse_area.size_x,0);
		  else if (ue.event.mouse.coord.x > (mouse_area.start_x + mouse_area.size_x))
		     XWarpPointer (disp, None, None, 0,0,0,0,-mouse_area.size_x,0);
		  else if (ue.event.mouse.coord.y < mouse_area.start_y)
		     XWarpPointer (disp, None, None, 0,0,0,0,0,mouse_area.size_y);
		  else if (ue.event.mouse.coord.y > (mouse_area.start_x + mouse_area.size_y))
		     XWarpPointer (disp, None, None, 0,0,0,0,0,-mouse_area.size_y);
	       }
	       */
	       
	       event_queue.push (ue);
	       break;

	    case SDL_MOUSEBUTTONDOWN:
	       ue.type = UserEvent::button_press;
	       ue.event.mouse.button = event.button.button;
	       event_queue.push (ue);
	       MakeMouseButtonPress (ue.event.mouse.button);
	       break;

	    case SDL_MOUSEBUTTONUP:
	       ue.type = UserEvent::button_release;
	       ue.event.mouse.button = event.button.button;
	       event_queue.push (ue);
	       MakeMouseButtonRelease (ue.event.mouse.button);
	       break;
	       
	    case SDL_QUIT:
	       //exiting = true;
	       break;

	    default:
	       cout << "Unknown SDL event!" << endl;
	       break;
	 }

	 /*
	 Uint8 *keys;
	 keys = SDL_GetKeyState (0);
	 */
      }
   }
   
   void
   SDLEvent::MakeKeyPress (Key k)
   {
      /*
      current_key = k;
      if (save_string_key)
	 if (!(k.unicode & 0xff80))
	    current_string_key += (k.unicode & 0x7f);
      */
   }

   void
   SDLEvent::MakeKeyRelease (Key k)
   {
      if (current_key == k)
	 current_key = (Key)0;
   }

   void
   SDLEvent::MakeMouseButtonPress (MouseButton b)
   {
      current_mouse_button = b;
   }

   void
   SDLEvent::MakeMouseButtonRelease (MouseButton b)
   {
      if (current_mouse_button == b)
	 current_mouse_button = 0;
   }
}
}
}

