/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: glxwindow.cc,v 1.7 2004/06/15 12:57:37 jd Exp $

   Created 03/22/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/window/glxwindow.cc
  \brief base glx window impl.
*/

#include "leg/support/window/glx/glxwindow.h"
#include "leg/support/utils/errors.h"
#include <GL/glu.h>
#include <iostream>

using leg::support::utils::Warning;
using leg::support::utils::Error;
using namespace std;

namespace leg
{
namespace support
{
namespace window
{
   BaseGLXWindow::BaseGLXWindow (DisplayConnect& disp):	 Window (disp),
							 modes (0),
							 scr (-1),
							 desk_mode (-1),
							 best_mode (-1),
							 visual_info (0),
							 context (0)
   {
   }

   BaseGLXWindow::~BaseGLXWindow()
   {
   }

   void
   BaseGLXWindow::GetGlxVersion()
   {
      int maj=0,min=0;
      display.GetGLWMVersion (maj,min);
   }

   void
   BaseGLXWindow::CreateScreen()
   {
      internal::Display* disp= display.Get();
     
      if (!disp)
	Error ("no display at all !");
       
      scr= DefaultScreen (disp);
      const char* serv_str= glXQueryServerString (disp, scr, 0);
      const char* ext_str= glXQueryExtensionsString (disp, scr);

      if( !serv_str || !ext_str)
	 ;/*Warning ("No information about screen could found. Continuing anyway.",
		"leg::support::window::BaseGLXWindow::CreateScreen()");*/
   }

   internal::Window
   BaseGLXWindow::CreateXWindow ()
   {
      unsigned long mask;
      if (!attr.GetFullScreenUse() && attr.GetDecorationUse())
	 mask = CWColormap | CWEventMask | CWBorderPixel | CWBackPixel;
      else if (!attr.GetFullScreenUse())
	 mask = CWColormap | CWEventMask | CWBorderPixel | CWBackPixel | CWOverrideRedirect;
      else
	 mask = CWColormap | CWEventMask | CWBorderPixel | CWBackPixel | CWOverrideRedirect | CWSaveUnder | CWBackingStore;
      
      int x=0,y=0;
      attr.GetPosition (x,y);
      unsigned int w=0,h=0;
      attr.GetSize (w,h);
      internal::Display *di= display.Get();

      internal::Window win = XCreateWindow( di,
			   RootWindow (di, visual_info->screen),  // parent
			   x,y,					 // x,y position
			   w,h,
			   0,					 // border
			   visual_info->depth,
			   InputOutput,				 // class
			   visual_info->visual,
			   mask,
			   attr.GetXAttributes());

      return win;
   }

   // Under X at least, there is another way, with calling some specific 
   // functions that switch directly to fullscreen or window without
   // having to destroy the window: this is well better.
   void 
   BaseGLXWindow::SwitchToFullScreen()
   {
      if (!attr.GetFullScreenUse())
	 attr.SetFullScreenUse (true);
      Destroy();
      Create();
      
      //XF86VidModeSwitchToMode( drawable->GetDisplay(), scr, &modes[best_mode]);
      //XF86VidModeSetViewPort( drawable->GetDisplay(), scr, 0, 0);
   }

   void 
   BaseGLXWindow::SwitchToWindow()
   {
      if (attr.GetFullScreenUse())
	 attr.SetFullScreenUse (false);
      Destroy();
      Create();
      
      //XF86VidModeSwitchToMode( drawable->GetDisplay(), scr, &modes[desk_mode]);
      //XF86VidModeSetViewPort( drawable->GetDisplay(), scr, 0, 0);
   }

   Cursor
   DeleteXCursor (internal::Display *disp, internal::Window *win)
   {
      Pixmap		mask;
      XGCValues	xgc_val;
      GC		gc;
      XColor		color;
	
      mask= XCreatePixmap (disp, *win, 1,1,1);
      xgc_val.function= GXclear;
      gc = XCreateGC (disp, mask, GCFunction, &xgc_val);
      XFillRectangle (disp, mask, gc, 0,0,1,1);
      color.pixel=0;
      color.red=0;
      color.flags=4;
      Cursor cursor = XCreatePixmapCursor (disp, mask, mask, &color, &color, 0,0);
   
      XFreePixmap (disp, mask);
      XFreeGC (disp, gc);

      return cursor;
   }

}
}
}

