/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: xwindow.cc,v 1.4 2004/06/15 12:57:37 jd Exp $

   Created 03/11/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/window/glx/xwindow.cc
  \base XFree gl window impl.
*/

#include "leg/support/window/glx/glx13window.h"
#include "leg/support/utils/errors.h"
#include <cstdlib>

using leg::support::utils::Warning;
using leg::support::utils::Error;
using leg::support::utils::Info;
using namespace std;

namespace leg
{
namespace support
{
namespace window
{
   GLX13Window::GLX13Window (DisplayConnect& disp):  BaseGLXWindow (disp)
   {
      drawable_ptr = malloc (sizeof (DrawableType));
      drawable_ptr = reinterpret_cast<DrawableType*> (drawable_ptr);
      drawable = new (drawable_ptr) DrawableType;
      drawable->SetDisplay (disp.Get());
   }

   GLX13Window::~GLX13Window()
   {
      attr.SetKeyboardAutoRepeatMode (display.Get(), true);
      Destroy();
      //XFree (drawable->GetFBConfig());
      //XFree (config);
      drawable->~DrawableType();
      free (drawable_ptr);
   }

   void
   GLX13Window::Create()
   {
      GetGlxVersion();
      CreateScreen();
      CreateConfig();
      CreateVisual();
      CreateMainWindow();
      is_created = true;
   }

   void
   GLX13Window::Destroy()
   {
      internal::Display *disp= drawable->GetDisplay();
      if (!disp)
	 Error ("No display connexion is opened.","leg::support::window::GLX13Window::Destroy()");
      
      if (this->context){
	 drawable->LeaveContext();
	 glXDestroyContext (drawable->GetDisplay(), this->context);
	 this->context=0;
      }

      drawable->DestroyDrawable();
      XDestroyWindow (disp, drawable->GetWindow());

      if (attr.GetFullScreenUse())
         XF86VidModeSwitchToMode (disp, scr, modes[0]);
      XFree (modes);
      direct_rendered= false;
   }

   void 
   GLX13Window::SetAttributes (const Attributes& a)
   {
      ;//attr = a;
   }
   
   internal::FbConfig* const
   GLX13Window::CreateConfig()
   {
      internal::Display *disp = drawable->GetDisplay();
      int vid_rel_maj, vid_rel_min;
      int mode_num;
      
      if (attr.GetFullScreenUse()){
         if (XF86VidModeQueryVersion (disp, &vid_rel_maj, &vid_rel_min)){
	    XF86VidModeGetAllModeLines (disp, scr, &mode_num, &modes);
	    mode_info= *modes[0];
	 }

	 int i,dot;
	 unsigned int width=0,height=0;
         
         // getting the actual video-mode in order to be able to restore
         // it when leaving the program (in fullscreen, we must find our
	 // old resolution before we have started the program, and not the
         // program resolution...). So, the two vars have to be class data.
         // dot is the clock of the display.
	 XF86VidModeModeLine actual_mode;      
         XF86VidModeGetModeLine (disp, scr, &dot, &actual_mode);
         attr.GetSize (width,height);

         for (i=0; i<mode_num; ++i){
	    if ((modes[i]->hdisplay == actual_mode.hdisplay) && (modes[i]->vdisplay == actual_mode.vdisplay))
	       desk_mode = i;
	    if ((modes[i]->hdisplay==width) && (modes[i]->vdisplay==height)){
	       best_mode = i;
	       break;
	    }
	 }

	 if (XF86VidModeValidateModeLine (disp,scr,modes[i])!=True)
	    Warning ("XFree mode cannot be validated.","leg::support::window::GLX13Window::CreateConfig()");
      }
      
      /*
      int gnb=0;
      int *gattr= 0;//attr.GetGLWMAttributes (gnb);
      //if (!gattr)
      // Error("No glx attributes","leg::support::window::GLX13Window::CreateConfig()");

      config= glXChooseFBConfig (disp, scr, gattr, &gnb);
      if (!config)
	 Warning ("no fb config");
      */
   }

   void
   GLX13Window::CreateVisual()
   {
      int nb=0;
      visual_info= drawable->GetVisual (scr,attr.GetGLWMAttributes (nb));
   }

   void
   GLX13Window::CreateMainWindow()
   {
      internal::Display *di= drawable->GetDisplay();
      XSetWindowAttributes& xattr= *attr.GetXAttributes();
      
      context = drawable->CreateContext (0);

      unsigned int width = 0, height = 0;   
      attr.GetSize (width,height);
      
      if (attr.GetFullScreenUse()){
	 XSync (di, 0);
	 xattr.backing_store = NotUseful;
	 xattr.save_under = False;
      
	 int dot;
	 XF86VidModeModeLine actual_mode;      
	 XF86VidModeGetModeLine (di, scr, &dot, &actual_mode);

	 int dw,dh;
	 XF86VidModeSwitchToMode (di, scr, modes[best_mode]);
	 XF86VidModeSetViewPort (di, scr, 0, 0);
			
	 dw= modes[best_mode]->hdisplay;
	 dh= modes[best_mode]->vdisplay;
      }

      xattr.background_pixel=	0;
      xattr.border_pixel=	0;
      xattr.colormap = XCreateColormap (  di, 
					  RootWindow (di, visual_info->screen), 
					  visual_info->visual, 
					  AllocNone);
      
      xattr.event_mask =   KeyReleaseMask	|  ButtonPressMask 	|
			   ButtonReleaseMask    |  PointerMotionMask 	|
			   ButtonMotionMask     |  KeyPressMask		|
			   VisibilityChangeMask |  StructureNotifyMask;

      drawable->GetWindow() = XCreateWindow( di,
					     RootWindow( di, visual_info->screen),
					     0,0,width,height,
					     0,
					     visual_info->depth,
					     InputOutput,
					     visual_info->visual,
					     CWBorderPixel 	|
					     CWColormap 	|
					     CWEventMask,
					     attr.GetXAttributes());
      
      XMapWindow (di, drawable->GetWindow());
   
      if (!attr.GetFullScreenUse())
	 XSetStandardProperties (di, 
			      drawable->GetWindow(), 
			      attr.GetName().c_str(), 
			      attr.GetName().c_str(), 
			      None,
			      0,
			      0,
			      0);
      else{
	 XMoveWindow (di, drawable->GetWindow(), 0, 0);
	 XRaiseWindow (di, drawable->GetWindow());
	 XWarpPointer (di, None, drawable->GetWindow(), 0, 0, 0, 0, width/2, height/2);
	 XGrabKeyboard (di, drawable->GetWindow(), False, GrabModeAsync, GrabModeAsync, CurrentTime);
      }
 
      drawable->CreateDrawable (0);//attr.GetGLWMAttributes (nb));
      drawable->EnterContext (context);
      drawable->CheckDirectRendering (drawable->GetDisplay(), context);
   }

   XAttributes& 
   GLX13Window::GetAttributes()
   {
      return attr;
   }

   BaseDrawable&
   GLX13Window::GetDrawable()
   {
      return *drawable;
   }

   void
   GLX13Window::ShowCursor (bool show)
   {
      if (!show){
	 Cursor c = DeleteXCursor (display.Get(),&drawable->GetWindow());
	 XDefineCursor (display.Get(),drawable->GetWindow(),c);
      }
      else
	 XUndefineCursor (display.Get(),drawable->GetWindow());
   }

}
}
}

