/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: glx13drawableimpl.cc,v 1.1 2004/04/30 01:37:20 jd Exp $

   $Log: glx13drawableimpl.cc,v $
   Revision 1.1  2004/04/30 01:37:20  jd
   first release into glx and first support for interactivity

   Revision 1.2  2004/03/22 03:28:01  jd
   better glx 1.3 support and interface compatibility with glx 1.2

   Revision 1.1  2004/03/15 23:26:05  jd
   glx 1.3 compatibility next release, this file is a copy of the last drawableimpl.h. This is the same for the sources.

   Revision 1.2  2004/03/12 22:05:45  jd
   New revision

   Revision 1.1  2004/03/07 22:59:27  jd
   initial revision


 
   Created 02/18/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/window/glx13drawable.cc
  \brief glx 1.3 drawable support
*/

#include "leg/support/window/glx/glx13drawableimpl.h"
#include "leg/support/utils/errors.h"

namespace leg
{
namespace support
{
namespace window
{
namespace internal
{
   using leg::support::utils::Error;
   using leg::support::utils::Warning;
   
   GLX13DrawableImpl::GLX13DrawableImpl():GLXDrawableImpl()
   {
   }

   GLX13DrawableImpl::~GLX13DrawableImpl()
   {
      XFree (config);
   }

   internal::Context
   GLX13DrawableImpl::CreateContext (internal::Context shared)
   {
      Context tmp= glXCreateNewContext (display, *config, GLX_RGBA_TYPE, shared, GL_TRUE);   //TODO: colors and gltrue args
      return /*context=*/tmp;
   }

   void
   GLX13DrawableImpl::DestroyContext (internal::Context c)
   {
      glXDestroyContext (display,c);
   }

   void
   GLX13DrawableImpl::CreateDrawable (int *glx_attr)
   {
      drawable= glXCreateWindow (display, *config, window, glx_attr);

      // Back drawable is needed for pbuffering.
      // back_drawable= glXCreatePbuffer (display, *config, glx_attr);

      if (!drawable) //|| !back_drawable)
	 Error ("Could not create glx drawable.","leg::support::window::internal::GLX13DrawableImpl::CreateDrawable()");
   }

   void
   GLX13DrawableImpl::DestroyDrawable ()
   {
      using leg::support::utils::Warning;

      glXDestroyWindow (display, drawable);
      drawable = 0;
   }

   XVisualInfo* const
   GLX13DrawableImpl::GetVisual (int scr, int *glx_attr)
   {
      int gnb=0;
      int *gattr= 0;//attr.GetGLWMAttributes (gnb);
      //if (!gattr)
      // Error("No glx attributes","leg::support::window::GLX13Window::CreateConfig()");

      config= glXChooseFBConfig (display, scr, gattr, &gnb);
      if (!config)
	 Warning ("no fb config");

      visual_info= glXGetVisualFromFBConfig (display, *config);
      if (!visual_info)
	 Error ("Could not get visual.","leg::support::window::internal::GLX13DrawableImpl::DestroyWindow()");
      
      return visual_info;
   }   

   void
   GLX13DrawableImpl::SwapBuffers()
   {
      glXSwapBuffers (display, drawable);
   }
}
}
}
}

