/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: attributes.cc,v 1.5 2004/05/09 23:36:09 jd Exp $

   $Log: attributes.cc,v $
   Revision 1.5  2004/05/09 23:36:09  jd
   directory support for all the project, best windowing support, best interactivity support...

   Revision 1.4  2004/05/01 00:12:46  jd
   initial support for fullscreen

   Revision 1.3  2004/04/30 20:15:54  jechk
   Big merge.  See ChangeLog for details.

   Revision 1.2  2004/03/15 23:25:23  jd
   glx 1.2 compatibility first release

   Revision 1.1  2004/03/12 22:05:15  jd
   Initial revision


 
   Created 03/08/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/window/attributes.cc
  \Attributes for gl window rendering support.
*/

#include "leg/support/window/attributes.h"
#include "leg/support/utils/errors.h"

using namespace leg::support::utils;

namespace leg
{
namespace support
{
namespace window
{
   Attributes::Attributes( unsigned int w, unsigned int h): xpos (0), ypos (0),
							    width (w), height (h),
							    color (0), depth (0),
							    stencil (8),
							    red (0), green (0), blue (0), alpha (0),
							    name ("GNU/Leg GL Window renderable"),
							    fullscreen (false),
							    decoration (true),
							    keyboard_autorepeat (true)
   {
   }

   Attributes::~Attributes()
   {
   }

   Attributes::Attributes (const Attributes& a)
   {
      xpos= a.xpos;
      ypos= a.ypos;
      width= a.width;
      height= a.height;
      color= a.color;
      depth= a.depth;
      stencil= a.stencil;
      red= a.red;
      green= a.green;
      blue= a.blue;
      alpha= a.alpha;
      name= a.name;
      fullscreen= a.fullscreen;
      decoration= a.decoration;
      keyboard_autorepeat = a.keyboard_autorepeat;
   }
   
   Attributes&
   Attributes::operator = (const Attributes& a)
   {
      xpos= a.xpos;
      ypos= a.ypos;
      width= a.width;
      height= a.height;
      color= a.color;
      depth= a.depth;
      stencil= a.stencil;
      red= a.red;
      green= a.green;
      blue= a.blue;
      alpha= a.alpha;
      name= a.name;
      fullscreen= a.fullscreen;
      decoration= a.decoration;
      keyboard_autorepeat = a.keyboard_autorepeat;

      return *this;
   }

   void
   Attributes::SetPosition (int x, int y)
   {
      xpos=x;
      ypos=y;
   }

   void
   Attributes::GetPosition (const int& x, const int& y) const
   {
      // This is done to avoid user having the possibility to change the
      // values threw the returned one. He will have to explicitly tell
      // he wants to modify them by using const_cast too.
      // This is the same policy for all other 'same' functions.
      int &x1= const_cast<int&>(x);
      int &y1= const_cast<int&>(y);
      x1=xpos;
      y1=ypos;
   }

   void
   Attributes::SetSize (unsigned int w, unsigned int h)
   {
      width=w;
      height=h;
   }

   void
   Attributes::GetSize (unsigned int& w, unsigned int& h)
   {
      w=width;
      h=height;
   }

   void
   Attributes::SetColorBufferSize (int c)
   {
      color=c;
   }

   void
   Attributes::SetColorsSize (int r, int g, int b, int a)
   {
      if ((r+g+b+a>static_cast<int>(color)) || ((r+g+b+a)<0))
	 Error ("Bad colors size","leg::support::window::Attributes::SetColorsSize()");
      red=r;
      green=g;
      blue=b;
      alpha=a;
   }
   
   int
   Attributes::GetColorBufferSize () const
   {
      return color;
   }

   void
   Attributes::SetDepthBufferSize (int d)
   {
      depth=d;
   }

   int
   Attributes::GetDepthBufferSize () const
   {
      return depth;
   }

   void
   Attributes::SetStencilBufferSize (int s)
   {
      stencil=s;
   }

   int
   Attributes::GetStencilBufferSize () const
   {
      return stencil;
   }

   void
   Attributes::SetName (std::string& n)
   {
      name=n;
   }

   const std::string&
   Attributes::GetName () const
   {
      return name;
   }

   void
   Attributes::SetFullScreenUse (bool f)
   {
      fullscreen=f;
   }

   bool
   Attributes::GetFullScreenUse () const
   {
      return fullscreen;
   }

   void
   Attributes::SetDecorationUse (bool d)
   {
      decoration=d;
   }

   bool
   Attributes::GetDecorationUse() const
   {
      return decoration;
   }
}
}
}

