/* This file is part of GNU Libraries and Engines for Games.

   $Id: warning.cc,v 1.2 2004/04/30 20:15:54 jechk Exp $
   $Log: warning.cc,v $
   Revision 1.2  2004/04/30 20:15:54  jechk
   Big merge.  See ChangeLog for details.

   Revision 1.1.1.1  2004/04/25 23:22:47  jd
   start on zionarea

   Revision 1.1  2004/03/10 20:46:58  jd
   initial revision



   Created 03/10/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/utils/warning.cc
  \brief Warning handlings.
*/

#include "leg/support/utils/warning.h"
#include <iostream>

using namespace std;

namespace leg
{
namespace support
{
namespace utils
{
namespace error
{
   const std::string str_head= "Warning: ";

   Warning::Warning(): Issue(str_head)
   {
   }
   
   Warning::Warning (const std::string& msg): Issue(str_head,msg)
   {
   }

   Warning::Warning (const std::string& msg, const std::string& location): Issue(str_head,msg,location)
   {
   }

   Warning::Warning (const std::string& msg, const std::string& location, int strerr_val): Issue(str_head,msg,location,strerr_val)
   {
   }
}
}
}
}

