/* This file is part of GNU Libraries and Engines for Games.

   $Id: timing.cc,v 1.2 2004/03/03 03:50:02 jechk Exp $
   $Log: timing.cc,v $
   Revision 1.2  2004/03/03 03:50:02  jechk
   Changed some names, comments and other things for consistency.

   Revision 1.1  2004/03/03 02:05:22  jechk
   Merged many changes.  See ChangeLog for details.


   Created 2/18/04 by Jeff Binder <bindej@rpi.edu>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/timing/timing.cc
  \brief Miscellaneous time utilities.
*/

#include "leg/support/timing/timing.h"

namespace leg
{

namespace support
{

namespace timing
{

struct timeval
operator + (const struct timeval &x, const struct timeval &y)
{
  struct timeval result;

  result.tv_sec = x.tv_sec + y.tv_sec;
  result.tv_usec = x.tv_usec + y.tv_usec;

  if (result.tv_usec > 1000000)
    {
      result.tv_usec -= 1000000;
      ++result.tv_sec;
    }

  return result;
}

struct timeval
operator - (const struct timeval &x, const struct timeval &y)
{
  struct timeval result;

  result.tv_sec = x.tv_sec - y.tv_sec;
  result.tv_usec = x.tv_usec - y.tv_usec;

  if (result.tv_usec < 0)
    {
      result.tv_usec += 1000000;
      --result.tv_sec;
    }

  return result;
}

}

}

}
