/* This file is part of GNU Libraries and Engines for Games.

   $Id: attribute.cc,v 1.2 2004/03/03 03:50:02 jechk Exp $
   $Log: attribute.cc,v $
   Revision 1.2  2004/03/03 03:50:02  jechk
   Changed some names, comments and other things for consistency.

   Revision 1.1  2004/03/03 02:05:22  jechk
   Merged many changes.  See ChangeLog for details.


   Created 01/27/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/threads/attribute.cc
  \brief First support of thread attributes for Leg.
*/

#include "leg/support/threads/attribute.h"
#include <exception>
#include <iostream>

namespace leg
{
namespace support
{
namespace threads
{

using namespace std;

Attribute::Attribute ()
{
   Construct ();
}

//Attribute (const Attribute&);

Attribute::~Attribute ()
{
   if (constructed)
      Destroy ();
}

//Attribute& operator= (const Attribute&);

void Attribute::Construct ()
{
   if( pthread_attr_init (&attributes)!= 0)
      {
	 cout << "leg::support::threads::Attribute::construct (): Error: could not initialized attributes." << endl;
	 throw std::exception ();
      }
   constructed = true;
}

void Attribute::Destroy ()
{
   if( pthread_attr_destroy (&attributes)!= 0)
      {
	 cout << "leg::support::threads::Attribute::destroy (): Error: could not destroy attributes." << endl;
	 throw std::exception ();
      }
   constructed = false;
}

#ifndef WIN32
void Attribute::SetSchedulePolicy (ScheduleAlgorithm algo)
{
   pthread_attr_setschedpolicy (&attributes, algo);
}

void Attribute::GetScheduleParam (ScheduleParam* sp)
{
   pthread_attr_getschedparam (&attributes, sp);
}

void Attribute::SetScheduleParam (ScheduleParam* sp)
{
   pthread_attr_setschedparam (&attributes, sp);
}
#endif
}
}
}
