/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: $

   Created 07/28/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/model/modelclass.cc
  \brief model class.
*/

#include "leg/support/model/modelclass.h"
#include <iostream>

namespace leg
{
namespace support
{
namespace model
{
   Model::Model(): Entity()
   {
   }

   Model::Model (const Model& m): Entity (static_cast<const Entity&> (m))
   {
      Copy (m);
   }

   Model::~Model()
   {
      std::list<Meshes*>::iterator i = mesh_list.begin();
      for (;i!=mesh_list.end();++i)
	 delete *i;
   }
   
   void
   Model::AddMesh (Meshes& mesh)
   {
      mesh_list.push_back (&mesh);
   }

   // free all the memory allocated for this model (when no more used).
   void
   Model::Free()
   {
   }

   GLuint
   Model::MakeDisplayList()
   {
      GLuint id = glGenLists (1);
      glNewList (id,GL_COMPILE);
      glPushMatrix();
      std::list<Meshes*>::iterator i;
      Meshes *tmp = 0;
      
      GLuint tri_nb;
      tri_nb = 0;
      
      for (i=mesh_list.begin();i!=mesh_list.end();++i){
	 tmp = *i;
	 
	 glPushClientAttrib(GL_ALL_ATTRIB_BITS);
	 glMaterialfv (GL_FRONT,GL_AMBIENT,(*i)->material.a);
	 glMaterialfv (GL_FRONT,GL_DIFFUSE,(*i)->material.d);
	 glMaterialfv (GL_FRONT,GL_SPECULAR,(*i)->material.s);
	 glMaterialf (GL_FRONT,GL_SHININESS,(*i)->material.h);

	 glBegin (tmp->tri_org);
	 for (GLuint j=0; j<tmp->count; ++j){
	    glBindTexture (GL_TEXTURE_2D,0);
	    for (GLuint k = 0; k<3; ++k){
	       glColor4fv (&tmp->col.d[12*j+4*k]);
	       glNormal3fv (&tmp->norm.d[9*j+3*k]);
	       glTexCoord2fv (&tmp->tex.d[6*j+2*k]);
	       glVertex3fv (&tmp->vert.d[9*j+3*k]);
	    }
	    ++tri_nb;
	    glPopClientAttrib();
	 }
	 glEnd();
      }
      
      glPopMatrix();
      glEndList();

      std::cout << "Model has " << tri_nb << " triangles." << std::endl;
      
      return id;
   }

   void
   Model::Copy (const Model& m)
   {
      std::list<Meshes*> *tmp_list = const_cast<std::list<Meshes*>*> (&m.mesh_list);
      std::list<Meshes*>::iterator i = tmp_list->begin();

      for (;i!=tmp_list->end();++i)
	 mesh_list.push_back (new Meshes (**i));
   }
}
}
}
