/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: $

   Created 07/28/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/model/meshes.cc
  \brief meshes for models.
*/

#include "leg/support/model/meshes.h"
#include "leg/support/utils/errors.h"

namespace leg
{
namespace support
{
namespace model
{
   VerticesData::VerticesData()
   {
   }

   VerticesData::~VerticesData()
   {
      if (d)
	 delete [] d;
      d = 0;
      q = 0;
   }
   

   Meshes::Meshes():
      tri_org (triangles),
      count (0)
   {
   }

   Meshes::Meshes (uint faces_nb):
      tri_org (triangles),
      count (faces_nb)
   {
      uint much = 0;

      if (tri_org == triangles || tri_org == tri_strip || tri_org == tri_fan)
	 much = 9;
      else
	 support::utils::Error ("Non triangle faces not yet supported.","support::model::Meshes::Meshes");

      vert.q = count * much;
      vert.d = new real[vert.q];

      norm.q = count * much;
      norm.d = new real[norm.q];

      much = 12;

      col.q = count * much;
      col.d = new real[col.q];

      much = 6;

      tex.q = count * much;
      tex.d = new real[tex.q];
   }

   Meshes::Meshes (const Meshes& m)
   {
      Copy (m);
   }

   Meshes::~Meshes()
   {
      // freeing vert.d,norm.d... is done in their respective destructors.
      // But what about textures ?
   }

   const Meshes&
   Meshes::operator = (const Meshes& m)
   {
      Copy (m);
      return *this;
   }

   void
   Meshes::Copy (const Meshes& m)
   {
      vert = m.vert;
      norm = m.norm;
      col  = m.col;
      tex  = m.tex;
      texture = m.texture;
      material = m.material;
      tri_org = m.tri_org;
   }
   
}
}
}
