/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: $

   Created 07/28/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/model/loader.cc
  \brief model format loader static class.
*/

#include "leg/support/model/loader.h"
#include "leg/support/model/formatleg.h"
#ifdef HAVE_LIB3DS
#include "leg/support/model/format3ds.h"
#endif
#include "leg/support/model/formatmd2.h"

#include "leg/support/utils/errors.h"
#include <iostream>

// This has to be redefined each time a new format is supported.
//typedef TYPELIST_1 (leg::support::model::Format3ds)   FormatDataBase;
//const uint format_database_entry_nb = Loki::TL::Length<FormatDataBase>::value;

namespace leg
{
namespace support
{
namespace model
{
   Model&
   Loader::LoadModel (const std::string& filename)
   {
      BaseFormatLoader* loader = 0;
      std::cout << "Loading model " << filename << std::endl;
      
      if (filename.find (".lmd") < filename.length())
	 loader = new FormatLeg;
      else if (filename.find (".3ds") < filename.length()){
	 #ifdef HAVE_LIB3DS
	 loader = new Format3ds;
	 #else
	 support::utils::Error ("Unsupported format.","support::model::Loader::LoadModel");
	 #endif
      }
      else if (filename.find (".3DS") < filename.length()){
	 #ifdef HAVE_LIB3DS
	 loader = new Format3ds;
	 #else
	 support::utils::Error ("Unsupported format.","support::model::Loader::LoadModel");
	 #endif
      }
      else if (filename.find (".md2") < filename.length())
	 loader = new FormatMd2;
      else
	 support::utils::Error ("Unknown model format.","support::model::Loader::LoadModel");
      
      return loader->Load (filename);
   }

   Model&
   Loader::LoadModel (const std::string& filename, float rescale)
   {
      BaseFormatLoader* loader = 0;
      std::cout << "Loading model " << filename << std::endl;

      if (filename.find (".lmd") < filename.length())
	 loader = new FormatLeg;
      else if (filename.find (".3ds") < filename.length()){
	 #ifdef HAVE_LIB3DS
	 loader = new Format3ds;
	 #else
	 support::utils::Error ("Unsupported format.","support::model::Loader::LoadModel");
	 #endif
      }
      else if (filename.find (".3DS") < filename.length()){
	 #ifdef HAVE_LIB3DS
	 loader = new Format3ds;
	 #else
	 support::utils::Error ("Unsupported format.","support::model::Loader::LoadModel");
	 #endif
      }
      else if (filename.find (".md2") < filename.length())
	 loader = new FormatMd2;
      else
	 support::utils::Error ("Unknown model format.","support::model::Loader::LoadModel");
 
      loader->SetFileRescale (rescale);
      
      return loader->Load (filename);
   }
}
}
}

