/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: $

   Created 07/28/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/model/entity.cc
  \brief model entity.
*/

#include "leg/support/model/modelclass.h"

namespace leg
{
namespace support
{
namespace model
{
   Entity::Entity(): name ("undefined"),
		     type (normal),
		     mesh_type (static_mesh),
		     v_test (do_test),
		     bounding (box)
   {
   }

   Entity::Entity (const Entity& me)
   {
      Copy (me);
   }

   Entity::~Entity()
   {
   }

   const Entity&
   Entity::operator = (const Entity& me)
   {
      Copy (me);
      return *this;
   }

   void
   Entity::SetName (const std::string& n)
   {
      name = n;
   }

   void
   Entity::Copy (const Entity& me)
   {
      name = me.name;
      name+= "'";

      pos = me.pos;
      ori = me.ori;
      size = me.size;
      kind = me.kind;
      type = me.type;
      v_test = me.v_test;
      bounding = me.bounding;
   }
}
}
}
