/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: viewport.cc,v 1.1 2004/05/15 13:30:16 jd Exp $

   $Log: viewport.cc,v $
   Revision 1.1  2004/05/15 13:30:16  jd
   first support for gl viewing


 
   Created 05/14/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/graphics/viewport.cc
  \brief gl viewport/perspectives/views.
*/

#include "leg/support/graphics/viewport.h"
#include <GL/gl.h>

namespace leg
{
namespace support
{
namespace graphics
{

   Viewport::Viewport (int orig_x, int orig_y, unsigned int w, unsigned int h):	 origin_w (orig_x),
										 origin_h (orig_y),
										 width (w),
										 height (h),
										 near (0),
										 far (1)
   {
   }

   Viewport::~Viewport()
   {
   }

   void
   Viewport::Set()
   {
      glViewport (origin_w, origin_h, static_cast<GLsizei> (width), static_cast<GLsizei> (height));
   }

   void
   Viewport::Set (int ox, int oy, unsigned int w, unsigned int h)
   {
      origin_w = ox;
      origin_h = oy;
      width = w;
      height = h;
      Set();
   }

   void
   Viewport::GetPosition (int& ox, int& oy) const
   {
      ox = origin_w;
      oy = origin_h;
   }

   void
   Viewport::GetSize (unsigned int& w, unsigned int& h) const
   {
      w = width;
      h = height;
   }

   void
   Viewport::SetDepthRange (float n, float f)
   {
      near = n;
      far = f;

      if (near < 0 || near > 1)
	 near = 0;
      if (far > 1 || far < 0)
	 far = 1;

      glDepthRange (near,far);
   }

   void
   Viewport::GetDepthRange (float& n, float& f) const
   {
      n = near;
      f = far;
   }

}
}
}
