/* This file is part of GNU Libraries and Engines for Games.

   $Id: guile.cc,v 1.1 2004/04/30 20:15:54 jechk Exp $
   $Log: guile.cc,v $
   Revision 1.1  2004/04/30 20:15:54  jechk
   Big merge.  See ChangeLog for details.



   Created 4/26/04 by Jeff Binder <bindej@rpi.edu>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/graphics/guile.cc
  \brief Guile bindings for graphics.
*/

#include "leg/support/graphics/graphics.h"

#if GUILE
#include "leg/support/guile/guile.h"
#endif // GUILE

using namespace std;
using namespace leg::support::guile;

namespace leg
{
namespace support
{
namespace graphics
{

#if GUILE

struct GuileStartup
{
  GuileStartup ()
  {
    support::guile::internal::StartGuile ();


    guile::AddType<Quadric> ("quadric");
    guile::AddConstructorBinding0<Quadric> ("new-quadric");
   
    guile::AddMemberBinding0<Quadric, GLenum, &Quadric::GetOrientation> ("get-quadric-orientation");
    guile::AddVoidMemberBinding1<Quadric, GLenum, &Quadric::SetOrientation> ("set-quadric-orientation!");

    guile::AddMemberBinding0<Quadric, GLenum, &Quadric::GetDrawStyle> ("get-quadric-draw-style");
    guile::AddVoidMemberBinding1<Quadric, GLenum, &Quadric::SetDrawStyle> ("set-quadric-draw-style!");

    guile::AddMemberBinding0<Quadric, GLenum, &Quadric::GetNormals> ("get-quadric-normals");
    guile::AddVoidMemberBinding1<Quadric, GLenum, &Quadric::SetNormals> ("set-quadric-normals!");

    guile::AddMemberBinding0<Quadric, bool, &Quadric::GetTextureCoords> ("get-quadric-texture-coordinates");
    guile::AddVoidMemberBinding1<Quadric, bool, &Quadric::SetTextureCoords> ("set-quadric-texture-coordinates!");

    guile::AddVoidMemberBinding3<Quadric, real, int, int, &Quadric::DrawSphere> ("draw-sphere!");
    guile::AddVoidMemberBinding5<Quadric, real, real, real, int, int, &Quadric::DrawCylinder> ("draw-cylinder!");
    guile::AddVoidMemberBinding4<Quadric, real, real, int, int, &Quadric::DrawDisk> ("draw-disk!");
    guile::AddVoidMemberBinding6<Quadric, real, real, int, int, real, real, &Quadric::DrawPartialDisk> ("draw-partial-disk!");


    
    guile::AddVoidBinding2<GLenum, bool, SetGlobalOption> ("set-global-option!");
    guile::AddBinding1<bool, GLenum, GetGlobalOption> ("get-global-option");

    guile::AddVoidBinding2<GLenum, bool, SetGlobalClientOption> ("set-global-client-option!");
    guile::AddBinding1<bool, GLenum, GetGlobalClientOption> ("get-global-client-option");

    guile::AddType<GLConfig> ("gl-config");
    guile::AddConstructorBinding0<GLConfig> ("new-gl-config");

    guile::AddVoidMemberBinding2<GLConfig, GLenum, bool, &GLConfig::SetOption> ("set-gl-config-option!");
    guile::AddMemberBinding1<GLConfig, bool, GLenum, &GLConfig::GetOption> ("get-gl-config-option");
    guile::AddMemberBinding1<GLConfig, bool, GLenum, &GLConfig::IsOptionStored> ("gl-config-manages-option?");
    guile::AddVoidMemberBinding1<GLConfig, GLenum, &GLConfig::RemoveOption> ("remove-gl-config-option!");

    guile::AddVoidMemberBinding2<GLConfig, GLenum, bool, &GLConfig::SetClientOption> ("set-gl-config-client-option!");
    guile::AddMemberBinding1<GLConfig, bool, GLenum, &GLConfig::GetClientOption> ("get-gl-config-client-option");
    guile::AddMemberBinding1<GLConfig, bool, GLenum, &GLConfig::IsClientOptionStored> ("gl-config-manages-client-option?");
    guile::AddVoidMemberBinding1<GLConfig, GLenum, &GLConfig::RemoveClientOption> ("remove-gl-config-client-option!");

    guile::AddVoidMemberBinding0<GLConfig, &GLConfig::Push> ("push-gl-config!");
    guile::AddVoidMemberBinding0<GLConfig, &GLConfig::Pop> ("pop-gl-config!");
    guile::AddVoidMemberBinding0<GLConfig, &GLConfig::EnableDisplayList> ("enable-gl-config-display-list!");
    guile::AddVoidMemberBinding0<GLConfig, &GLConfig::DisableDisplayList> ("disable-gl-config-display-list!");

    
    guile::LoadFile (DATADIR "/leg/scheme/graphics.scm");
  }
} guile_startup;

#endif // GUILE

}
}
}
