/* This file is part of GNU Libraries and Engines for Games.

   $Id: timing-class.cc,v 1.1 2004/05/13 04:16:02 jechk Exp $
   $Log: timing-class.cc,v $
   Revision 1.1  2004/05/13 04:16:02  jechk
   Split timing into two parts; moved message to libs.

   Revision 1.2  2004/03/03 03:50:02  jechk
   Changed some names, comments and other things for consistency.

   Revision 1.1  2004/03/03 02:05:22  jechk
   Merged many changes.  See ChangeLog for details.


   Created 2/18/04 by Jeff Binder <bindej@rpi.edu>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file libs/timing/timing-class.cc
  \brief The Timing class, which manages timers and time units.
*/

#include <algorithm>

#include "leg/libs/timing/timing.h"

namespace leg
{

namespace libs
{

namespace timing
{

Timing::Timing (double units_per_sec, support::timing::game_time current_time)
  : support::timing::Timing (units_per_sec, current_time),
    thread ()
{
  thread.Create ();
}



Timing::TimerThread::TimerThread ()
  : support::threads::Thread ()
{
}

void
Timing::TimerThread::AddTimer (Timer *timer)
{
  timers.push_front (timer);
}

void
Timing::TimerThread::RemoveTimer (Timer *timer)
{
  timers.erase (find (timers.begin (), timers.end (), timer));
}

void *
Timing::TimerThread::Go (void *args)
{
  struct timeval tv;

  for (;;)
    {
      gettimeofday (&tv, NULL);
      for (std::list<Timer *>::iterator i = timers.begin (); i != timers.end (); ++i)
	{
	  (*i)->Ping (tv);
	}
    }
}

}

}

}
